/******************************************
 *** Sparing w programowaniu zespolowym
 *** 8 maja 2004 / Politechnika Poznanska
 ***
 *** Zadanie G - Hiperlaser
 *** Autor programu: Wladyslaw Bodzek
 *****************************************/
#include <stdio.h>
#include <stdlib.h>
#include <cmath>


#define MAX_N		500
#define ZERO		1e-7
#define sqr(a)		((a)*(a))
#define PI		(acos((float)(0))*2)

using namespace std;
typedef struct {
    long double x, y;
    long double r;
} BASE;
typedef struct {
    long double a, b, c;
} LINE;
typedef struct {
    long double x, y;
} POINT;
int N;
BASE d[MAX_N];
int checked;
int max;

void test_line_p( POINT &p1, POINT &p2 )
{
    LINE l;
    int i, m=0;
    if (fabs(p2.x-p1.x)>ZERO) {
	l.a=-(p1.y-p2.y)/(p1.x-p2.x);
	l.b=1;
	l.c=-p1.y-l.a*p1.x;
    } else if (fabs(p2.y-p1.y)>ZERO) {
	l.a=1;
	l.b=-(p1.x-p2.x)/(p1.y-p2.y);
	l.c=-p1.x-l.b*p1.y;
    } else {
	printf("line_p(): error!\n");
	exit(1);
    }
    checked=1;
    for (i=0;i<N;i++)
	if (fabs(l.a*d[i].x+l.b*d[i].y+l.c)/sqrt(l.a*l.a+l.b*l.b)<=d[i].r+ZERO)
	    m++;
    if (m>max)
	max=m;
}

POINT rotate_p( POINT &s, POINT &p, long double alpha )
{
    POINT a;
    a.x=(p.x-s.x)*cos(alpha)-(p.y-s.y)*sin(alpha)+s.x;
    a.y=(p.x-s.x)*sin(alpha)+(p.y-s.y)*cos(alpha)+s.y;
    return a;
}

POINT middlew_p( POINT &p1, POINT &p2, long double w1, long double w2 )
{
    POINT a;
    a.x=p1.x+(p2.x-p1.x)*w1/(w1+w2);
    a.y=p1.y+(p2.y-p1.y)*w1/(w1+w2);
    return a;
}

POINT move_p( POINT &p, long double r, long double alpha )
{
    POINT s;
    s.x=p.x+r*cos(alpha);
    s.y=p.y+r*sin(alpha);
    return s;
}


void check_p( BASE &p1, BASE &p2 )
{
    POINT s1, s2, t, t1, t2;
    long double d=sqrt(sqr((p1.x-p2.x))+sqr(p1.y-p2.y));
    long double a, b, c, e, f;
    if (d<ZERO)
	return;
    s1.x=p1.x; s1.y=p1.y; s2.x=p2.x; s2.y=p2.y;
    if (fabs(p1.r+p2.r-d)<ZERO) {
	// 3 styczne - okregi styczne zewnetrznie
	a=acos((p1.r-p2.r)/d);
	b=atan2(p2.y-p1.y,p2.x-p1.x);
	t1=move_p(s1,p1.r,b+a);
	t2=move_p(s2,p2.r,b+a);
	test_line_p(t1,t2);
	t1=move_p(s1,p1.r,b-a);
	t2=move_p(s2,p2.r,b-a);
	test_line_p(t1,t2);
	
	t=middlew_p(s1,s2,p1.r,p2.r);
	t1=rotate_p(t,s1,PI/2);
	t2=rotate_p(t,s2,PI/2);
	test_line_p(t1,t2);
    } else if (p1.r+p2.r<d) {
	// 4 styczne - okregi rozlaczne
	a=acos((p1.r-p2.r)/d);
	b=atan2(p2.y-p1.y,p2.x-p1.x);
	t1=move_p(s1,p1.r,b+a);
	t2=move_p(s2,p2.r,b+a);
	test_line_p(t1,t2);
	t1=move_p(s1,p1.r,b-a);
	t2=move_p(s2,p2.r,b-a);
	test_line_p(t1,t2);

	a=acos((p1.r+p2.r)/d);
	b=atan2(p2.y-p1.y,p2.x-p1.x);
	t1=move_p(s1,p1.r,b+a);
	t2=move_p(s2,p2.r,b+a+PI);
	test_line_p(t1,t2);
	t1=move_p(s1,p1.r,b-a);
	t2=move_p(s2,p2.r,b-a+PI);
	test_line_p(t1,t2);
    } else if (fabs(p1.r-p2.r-d)<ZERO) {
	// 1 styczna - okregi styczne wewnetrznie
	t=middlew_p(s1,s2,p1.r,-p2.r);
	t1=rotate_p(t,s1,PI/2);
	t2=rotate_p(t,s2,PI/2);
	test_line_p(t1,t2);
    } else if (p1.r<p2.r+d) {
	// 2 styczne - okregi zazebiaja sie
	a=acos((p1.r-p2.r)/d);
	b=atan2(p2.y-p1.y,p2.x-p1.x);
	t1=move_p(s1,p1.r,b+a);
	t2=move_p(s2,p2.r,b+a);
	test_line_p(t1,t2);
	t1=move_p(s1,p1.r,b-a);
	t2=move_p(s2,p2.r,b-a);
	test_line_p(t1,t2);
    } else {
	// 0 stycznych - jedne okrag wewnatrz drugiego 
    }
}


int main(void)
{
    int D, i, j;
    scanf("%d",&D);
    while (D--) {
	scanf("%d",&N);
	for (i=0;i<N;i++)
	    scanf("%Lf%Lf%Lf",&d[i].x,&d[i].y,&d[i].r);
	max=0;
	checked=0;
	for (i=0;i<N;i++)
	    for (j=i+1;j<N;j++)
		if (d[i].r>=d[j].r)
		    check_p(d[i],d[j]);
		else
		    check_p(d[j],d[i]);
	if (checked)
	    printf("%d\n",max);
	else
	    printf("%d\n",N);
    }
        
    return 0;
}
