/*********************************************************
  Sparing: 6 listopada 2004
  Zadanie: D - Wlamanie
  Autor:   Piotr Gawron
*********************************************************/

//bignumy zapozyczone od Wojtka Mruczkiewicza bez jego zgody ale na pewno by
//sie zgodzil gdyby wiedzial ;), po prostu mial startowac w sparingu wiec
//nie mozna mu bylo mowic :P
#ifndef NUMBER_H
#define NUMBER_H
#include<stdio.h>
#include <algorithm>
#include <cctype>
#include <iostream>
using namespace std;

#define MAX_SIZE 20
#define MAX_IN_SIZE 1000
#define MAX_OUT_SIZE 1000

class Number {
	typedef unsigned long base;
	typedef unsigned long long dbase;
public:
	Number();
	Number(int x);
	Number(int input, int output);
	Number(const Number & x);
	~Number();
	operator int();
	Number & operator = (int x);
	Number & operator = (char * X);
	Number & operator = (const Number & x);
	Number & operator += (const Number & x);
	Number & operator -= (const Number & x);
	Number & operator *= (const Number & x);
	Number & operator /= (const Number & x);
	Number & operator %= (const Number & x);
	Number & operator ^= (const Number & x);
	Number & operator |= (const Number & x);
	Number & operator &= (const Number & x);
	Number & operator += (int x);
	Number & operator -= (int x);
	Number & operator *= (int x);
	Number & operator /= (int x);
	Number & operator %= (int x);
	Number & operator ^= (int x);
	Number & operator |= (int x);
	Number & operator &= (int x);
	Number & operator <<= (int n);
	Number & operator >>= (int n);

	Number operator + (const Number & x) const;
	Number operator - (const Number & x) const;
	Number operator * (const Number & x) const;
	Number operator / (const Number & x) const;
	Number operator % (const Number & x) const;
	Number operator ^ (const Number & x) const;
	Number operator | (const Number & x) const;
	Number operator & (const Number & x) const;
	Number operator + (int x) const;
	Number operator - (int x) const;
	Number operator * (int x) const;
	Number operator / (int x) const;
	Number operator % (int x) const;
	Number operator ^ (int x) const;
	Number operator | (int x) const;
	Number operator & (int x) const;
	Number operator << (int n) const;
	Number operator >> (int n) const;

	Number & operator ++ ();
	Number & operator -- ();
	Number operator ++ (int);
	Number operator -- (int);

	bool operator == (const Number & x) const;
	bool operator != (const Number & x) const;
	bool operator < (const Number & x) const;
	bool operator > (const Number & x) const;
	bool operator <= (const Number & x) const;
	bool operator >= (const Number & x) const;
	bool operator == (int x) const;
	bool operator != (int x) const;
	bool operator < (int x) const;
	bool operator > (int x) const;
	bool operator <= (int x) const;
	bool operator >= (int x) const;

	void ToString(char str[MAX_OUT_SIZE]) const;
	int Normalize(char ch) const;
	char ReNormalize(int x) const;
	void SetOutputBase(int output);
	void SetInputBase(int input);

	friend istream & operator >> (istream & sin, Number & x);
	friend ostream & operator << (ostream & sout, const Number & x);
private:
	int DivMod(int x);
	Number operator * (base x) const;
	Number & operator *= (base x);
	int BinarySize() const;
	void SetBit(int n);

	static const int base_size;
	static const base base_mask;
	base W[MAX_SIZE];
	int in;
	int out;
};

Number operator + (int x, const Number y);
Number operator - (int x, const Number y);
Number operator * (int x, const Number y);
Number operator / (int x, const Number y);
Number operator % (int x, const Number y);
Number operator ^ (int x, const Number y);
Number operator | (int x, const Number y);
Number operator & (int x, const Number y);
bool operator == (int x, const Number y);
bool operator != (int x, const Number y);
bool operator < (int x, const Number y);
bool operator > (int x, const Number y);
bool operator <= (int x, const Number y);
bool operator >= (int x, const Number y);

#endif

const int Number::base_size = 32;
const Number::base Number::base_mask = 0xffffffff;

Number::Number() {
	out = in = 10;
	for (int i=0; i<MAX_SIZE; ++i)
		W[i]=0;
}

Number::Number(int x) {
	out = in = 10;
	for (int i=0; i<MAX_SIZE; ++i)
		W[i]=0;
	W[0] = x;
}

Number::Number(int input, int output) {
	in	= input;
	out	= output;
	for (int i=0; i<MAX_SIZE; ++i)
		W[i] = 0;
}

Number::Number(const Number & x) {
	in=x.in; out=x.out;
	for (int i=0; i<MAX_SIZE; ++i)
		W[i] =x.W[i];
}

Number::~Number() {
}

Number::operator int () {
	return W[0];
}

// The condition (this != &x) isn't necessary for any of the
// following assignment operators.
Number & Number::operator = (int x) {
	for (int i=0; i<MAX_SIZE; ++i)
		W[i]=0;
	W[0] = x;
	return *this;
}

Number & Number::operator = (char * X) {
	*this = 0;
	for (int i=0; X[i]; ++i) {
		int tmp;
		if ((tmp=Normalize(X[i])) >= 0) {
			*this *= (base)in;
			*this += tmp;
		} else
			return *this = 0;
	}
	return *this;
}

Number & Number::operator = (const Number & x) {
	in=x.in; out=x.out;
	for (int i=0; i<MAX_SIZE; ++i)
		W[i] = x.W[i];
	return *this;
}

Number & Number::operator += (const Number & x) {
	dbase c = 0;
	for (int i=0; i<MAX_SIZE; ++i) {
		c += (dbase)W[i] + (dbase)x.W[i];
		W[i] = c & base_mask;
		c >>= base_size;
	}
	return *this;
}

Number & Number::operator -= (const Number & x) {
	dbase c = 0;
	for (int i=0; i<MAX_SIZE; ++i) {
		c = (((dbase)1)<<base_size) + (dbase)W[i] - (dbase)x.W[i] - c;
		W[i] = c & base_mask;
		c = (c>>base_size) ? 0 : 1;
	}
	return *this;
}

Number & Number::operator *= (const Number & x) {
	Number tmp;
	for (int i=0; i<MAX_SIZE; ++i)
		tmp += (x*W[i]) << (base_size*i);
	return *this = tmp;
}

Number & Number::operator /= (const Number & x) {
	Number tmp, p, y=x;
	if (*this < y)
		return *this = 0;
	int i = BinarySize() - y.BinarySize();
	y <<= i;
	for (; i>=0; --i) {
		p += y;
		if (*this >= p)
			tmp.SetBit(i);
		else
			p -= y;
		y >>= 1;
	}
	return *this = tmp;
}

Number & Number::operator %= (const Number & x) {
	Number p, y=x;
	if (*this < y)
		return *this;
	int i = BinarySize() - y.BinarySize();
	y <<= i;
	for (; i>=0; --i) {
		p += y;
		if (*this < p)
			p -= y;
		y >>= 1;
	}
	return *this -= p;
}

Number & Number::operator ^= (const Number & x) {
	for (int i=0; i<MAX_SIZE; ++i)
		W[i] ^= x.W[i];
	return *this;
}

Number & Number::operator |= (const Number & x) {
	for (int i=0; i<MAX_SIZE; ++i)
		W[i] |= x.W[i];
	return *this;
}

Number & Number::operator &= (const Number & x) {
	for (int i=0; i<MAX_SIZE; ++i)
		W[i] &= x.W[i];
	return *this;
}

Number & Number::operator += (int x) {
	dbase c = x;
	for (int i=0; i<MAX_SIZE && c; ++i) {
        c += W[i];
		W[i] = c & base_mask;
		c >>= base_size;
	}
	return *this;
}

Number & Number::operator -= (int x) {
	dbase c = x;
	for (int i=0; i<MAX_SIZE && c; ++i) {
		c = (((dbase)1)<<base_size) + (dbase)W[i] - c;
		W[i] = c & base_mask;
		c = (c>>base_size) ? 0 : 1;
	}
	return *this;
}

Number & Number::operator *= (int x) {
	dbase c = 0;
	for (int i=0; i<MAX_SIZE; ++i) {
		c += (dbase)W[i] * (dbase)x;
		W[i] = c & base_mask;
		c >>= base_size;
	}
	return *this;
}

Number & Number::operator /= (int x) {
	dbase w = 0;
	for (int i=MAX_SIZE-1; i>=0; i--) {
		w = (w<<base_size) + W[i];
		W[i] = w / x;
		w %= x;
	}
	return *this;
}

Number & Number::operator %= (int x) {
	dbase w = 0;
	for (int i=MAX_SIZE-1; i>=0; i--) {
		w = (w<<base_size) + W[i];
		w %= x;
	}
	return *this = (w&base_mask);
}

Number & Number::operator ^= (int x) {
	W[0] ^= x;
	return *this;
}

Number & Number::operator |= (int x) {
	W[x] |= x;
	return *this;
}

Number & Number::operator &= (int x) {
	for (int i=1; i<MAX_SIZE; ++i)
		W[i] = 0;
	W[0] &= x;
	return *this;
}

Number & Number::operator <<= (int n) {
	int x = n/base_size;
	int y = n%base_size;
	int i;
	for (i=MAX_SIZE-1; i-x>=0; --i) {
		if (i+i < MAX_SIZE)
			W[i+1] |= (dbase)W[i-x]>>(base_size-y);
		W[i] = ((dbase)W[i-x]<<y) & base_mask;
	}
	for (; i>=0; --i)
		W[i] = 0;
	return *this;
}

Number & Number::operator >>= (int n) {
	int x = n/base_size;
	int y = n%base_size;
	int i;
	for (i=0; i+x<MAX_SIZE; ++i) {
		if (i-1 >= 0)
			W[i-1] |= (dbase)W[i+x]<<(base_size-y);
		W[i] = ((dbase)W[i+x]>>y) & base_mask;
	}
	for (; i<MAX_SIZE; ++i)
		W[i] = 0;
	return *this;
}

Number Number::operator + (const Number & x) const {
	Number ret = *this;
	return ret += x;
}

Number Number::operator - (const Number & x) const {
	Number ret = *this;
	return ret -= x;
}

Number Number::operator * (const Number & x) const {
	Number ret = *this;
	return ret *= x;
}

Number Number::operator / (const Number & x) const {
	Number ret = *this;
	return ret /= x;
}

Number Number::operator % (const Number & x) const {
	Number ret = *this;
	return ret %= x;
}

Number Number::operator ^ (const Number & x) const {
	Number ret = *this;
	return ret ^= x;
}

Number Number::operator | (const Number & x) const {
	Number ret = *this;
	return ret |= x;
}

Number Number::operator & (const Number & x) const {
	Number ret = *this;
	return ret &= x;
}

Number Number::operator + (int x) const {
	Number ret = *this;
	return ret += x;
}

Number Number::operator - (int x) const {
	Number ret = *this;
	return ret -= x;
}

Number Number::operator * (int x) const {
	Number ret = *this;
	return ret *= x;
}

Number Number::operator / (int x) const {
	Number ret = *this;
	return ret /= x;
}

Number Number::operator % (int x) const {
	Number ret = *this;
	return ret %= x;
}

Number Number::operator ^ (int x) const {
	Number ret = *this;
	return ret ^= x;
}

Number Number::operator | (int x) const {
	Number ret = *this;
	return ret |= x;
}

Number Number::operator & (int x) const {
	Number ret = *this;
	return ret &= x;
}

Number Number::operator << (int n) const {
	Number ret = *this;
	ret <<= n;
	return ret;
}

Number Number::operator >> (int n) const {
	Number ret = *this;
	ret >>=n;
	return ret;
}

Number & Number::operator ++ () {
	return *this += 1;
}

Number & Number::operator -- () {
	return *this -= 1;
}

Number Number::operator ++ (int) {
	Number ret = *this;
	*this += 1;
	return ret;
}

Number Number::operator -- (int) {
	Number ret = *this;
	*this -= 1;
	return ret;
}

bool Number::operator == (const Number & x) const {
	for (int i=0; i<MAX_SIZE; ++i)
		if (W[i] != x.W[i])
			return false;
	return true;
}

bool Number::operator != (const Number & x) const {
	return !(*this == x);
}

bool Number::operator < (const Number & x) const {
	int i;
	for (i=MAX_SIZE-1; i>=0 && W[i]==x.W[i];)
		--i;
	if (i<0 || W[i]>x.W[i])
		return false;
	return true;
}

bool Number::operator > (const Number & x) const {
	int i;
	for (i=MAX_SIZE-1; i>=0 && W[i]==x.W[i];)
		--i;
	if (i<0 || W[i]<x.W[i])
		return false;
	return true;
}

bool Number::operator <= (const Number & x) const {
	return !(*this > x);
}

bool Number::operator >= (const Number & x) const {
	return !(*this < x);
}

bool Number::operator == (int x) const {
	return *this == (Number)x;
}

bool Number::operator != (int x) const {
	return *this != (Number)x;
}

bool Number::operator < (int x) const {
	return *this < (Number)x;
}

bool Number::operator > (int x) const {
	return *this > (Number)x;
}

bool Number::operator <= (int x) const {
	return *this <= (Number)x;
}

bool Number::operator >= (int x) const {
	return *this >= (Number)x;
}

void Number::ToString(char str[MAX_OUT_SIZE]) const {
	Number tmp = *this;
	int n = 0;
	while (tmp != 0)
		str[n++] = ReNormalize(tmp.DivMod(out));
	if (n==0)
		str[n++] = '0';
	reverse(str, str+n);
	str[n] = '\0';
}

int Number::Normalize(char ch) const {
	if ('a'<=ch && ch<='z')
		ch -= 'a' - 10;
	else if ('A'<=ch && ch<='Z')
		ch -= 'A' - 10;
	else if ('0'<=ch && ch<='9')
		ch -= '0';
	else
		return -1;
	if (ch < in)
		return (int)ch;
	return -1;
}

char Number::ReNormalize(int x) const {
	if (0<=x && x<=9)
		return (char)(x+'0');
	else if (10<=x && x<=35)
		return (char)(x-10+'a');
	return '?';
}

void Number::SetOutputBase(int output) {
	out = output;
}

void Number::SetInputBase(int input) {
	in = input;
}

istream & operator >> (istream & sin, Number & x) {
	char strTmp[MAX_IN_SIZE];
	int i;
	while (isspace(sin.peek()))
		sin.get();
	for (i=0; i<MAX_IN_SIZE && x.Normalize(sin.peek())>=0; ++i)
		strTmp[i] = sin.get();
	strTmp[i] = '\0';
	x = strTmp;
	return sin;
}

ostream & operator << (ostream & sout, const Number & x) {
	char strTmp[MAX_OUT_SIZE];
	x.ToString(strTmp);
    return sout <<strTmp;
}

int Number::DivMod(int x) {
	dbase w = 0;
	for (int i=MAX_SIZE-1; i>=0; i--) {
		w = (w<<base_size) + W[i];
		W[i] = w/x;
		w = w%x;
	}
	return w & base_mask;
}

Number Number::operator * (base x) const {
	Number ret = *this;
	ret *= x;
	return ret;
}

Number & Number::operator *= (Number::base x) {
	dbase c = 0;
	for (int i=0; i<MAX_SIZE; ++i) {
		c += (dbase)W[i] * (dbase)x;
		W[i] = c & base_mask;
		c >>= base_size;
	}
	return *this;
}

int Number::BinarySize() const {
	int i, ret=0;
	for (i=0; i<MAX_SIZE && W[i]; ++i)
		ret += base_size;
	if (i==0)
		return 0;
	ret -= base_size;
	base tmp = W[--i];
	for (; tmp; ++ret)
		tmp >>= 1;
    return ++ret;
}

void Number::SetBit(int n) {
	W[n/base_size] |= 1 << (n%base_size);
}

Number operator + (int x, const Number y) {
	Number tmp = x;
	return tmp += y;
}

Number operator - (int x, const Number y) {
	Number tmp = x;
	return tmp -= y;
}

Number operator * (int x, const Number y) {
	Number tmp = x;
	return tmp *= y;
}

Number operator / (int x, const Number y) {
	Number tmp = x;
	return tmp /= y;
}

Number operator % (int x, const Number y) {
	Number tmp = x;
	return tmp %= y;
}

Number operator ^ (int x, const Number y) {
	Number tmp = x;
	return tmp ^= y;
}

Number operator | (int x, const Number y) {
	Number tmp = x;
	return tmp |= y;
}

Number operator & (int x, const Number y) {
	Number tmp = x;
	return tmp &= y;
}

bool operator == (int x, const Number y) {
	return y == x;
}

bool operator != (int x, const Number y) {
	return y != x;
}

bool operator < (int x, const Number y) {
	return y > x;
}

bool operator > (int x, const Number y) {
	return y < x;
}

bool operator <= (int x, const Number y) {
	return y >= x;
}

bool operator >= (int x, const Number y) {
	return y <= x;
}


int T[100];
typedef Number number;
number silnia(int i)
{
    number j=1;
    int k;
    for (k=2;k<=i;k++)
	j*=k;
    return j;
}
number odp=0;
void test(int ile_liczb)
{
    int i,j=-1;
    number up,down;
    int UP=0;
    int t[100];
    for (i=0;i<10;i++)
	t[i]=0;;
    for (i=1;i<=ile_liczb;i++)
    {
	UP+=T[i]+1;
	if (T[i-1]!=T[i])
	{
	    j++;
	    t[j]++;
	}
	else
	    t[j]++;
//	printf("%d ",T[i]);
    }
    up=silnia(ile_liczb);
    down=1;
    for (i=0;i<=j;i++)
	down*=silnia(t[i]);
//    printf("\n");
//    printf("%d\n",up/down);
    up*=silnia(UP);
//    printf("%d\n",up);
    for (i=1;i<=ile_liczb;i++)
	down*=silnia(T[i]+1);
    
//    printf("%d\n",up/down);
    odp+=up/down;
}
//int rek=0;
void generuj(int n, int i,int ile_liczb)
{
    
//    rek++;
//    printf("%d %d %d %d\n",n,i,ile_liczb,T[i-1]);
    if (i>ile_liczb||n>T[i-1]*(ile_liczb-i+1))
	return;
    if (n==0)
    {
	test(ile_liczb);
	return;
    }
    if (T[i-1]==0)
	return;
    if (T[i-1]>T[i])
    {
	T[i]++;
	generuj(n-1,i,ile_liczb);
	T[i]--;
    }
    generuj(n,i+1,ile_liczb);
}
int main()
{
    int n,d,k;
    number dni, godziny,minuty,sekundy;
    T[0]=100;
    scanf("%d",&d);
    while(d--)
    {
	odp=0;
	scanf("%d%d",&n,&k);
	
    generuj(k-n,1,n);
//    printf("%d\n",rek);
    sekundy=odp%60;
    odp/=60;
    minuty=odp%60;
    odp/=60;
    godziny=odp%24;
    odp/=24;
    dni=odp;
    cout<<dni<<":"<<godziny<<":"<<minuty<<":"<<sekundy<<'\n';
    }
    return 0;
}
