(*********************************************************
  Sparing: 6 listopada 2004
  Zadanie: F - Szejk
  Autor:   Wladyslaw Bodzek
*********************************************************)

{$MODE DELPHI}
{$R+,S+}

uses Math;

const 
  MAXN = 100000;

type
  point = record 
    x, y : Integer;
  end;
  pointslist = array[0..MAXN] of point;



function pgreater( var p1, p2 : point ):Boolean;
begin
  Result := (p1.x > p2.x) or ((p1.x = p2.x) and (p1.y > p2.y));
end;

function psmaller( var p1, p2 : point ):Boolean;
begin
  Result := (p1.x < p2.x) or ((p1.x = p2.x) and (p1.y < p2.y));
end;

procedure QuickSort( var A : pointslist; Lo, Hi: longint);
  procedure Sort(l, r: longint);
    var
      i, j : Integer;
      x, y : point;
  begin
    i := l; j := r; x := a[(l+r) DIV 2];
    repeat
      while psmaller(a[i],x) do i := i + 1;
      while psmaller(x,a[j]) do j := j - 1;
      if i <= j then begin
        y := a[i]; a[i] := a[j]; a[j] := y;
        i := i + 1; j := j - 1;
      end;
    until i > j;
    if l < j then Sort(l, j);
    if i < r then Sort(i, r);
  end;

begin
  Sort(Lo,Hi);
end;


var
  nsets, iset, n, i, j : Integer;
  p : pointslist;
  t : point;
  t1_count, t2_count : Integer;
  t1, t2 : array[0..MAXN] of Integer;
  w : double;
  
function direction( var p0, p1, p2 : point ):double;
begin
  Result := (double(p1.x)-p0.x)*(double(p2.y)-p0.y) - (double(p2.x)-p0.x)*(double(p1.y)-p0.y)
end;
  
function iterate_min( var w : Integer; count : Integer ):Integer;
begin
  Result := w;
  while (w < count - 1) and (p[w].x = p[w+1].x) do
    inc(w);
  inc(w);
end;

function iterate_max( var w : Integer; count : Integer ):Integer;
begin
  while (w < count - 1) and (p[w].x = p[w+1].x) do
    inc(w);
  Result := w;
  inc(w);
end;

function area( var p1, p2 : point ):double;
begin
  Result := (double(p2.x)-p1.x)*(double(p1.y)+p2.y)/2;
//  writeln('(',p1.x,',',p1.y,') , (',p2.x,',',p2.y,') => ',Result);
end;

    
begin
  readln(nsets);
  for iset := 1 to nsets do begin
    readln(n);
    for i := 0 to n - 1 do
      readln(p[i].x,p[i].y);
    QuickSort(p,0,n-1);
    
    t1_count := 0;
    i := 0;
    while i < n do begin
      j := iterate_max(i,n);
      while (t1_count >= 2) and (direction(p[t1[t1_count-2]],p[t1[t1_count-1]],p[j])>0) do
        dec(t1_count);      
      t1[t1_count] := j;
      inc(t1_count);
    end;

    t2_count := 0;
    i := 0;
    while i < n do begin
      j := iterate_min(i,n);
      while (t2_count >= 2) and (direction(p[t2[t2_count-2]],p[t2[t2_count-1]],p[j])<0) do
        dec(t2_count);      
      t2[t2_count] := j;
      inc(t2_count);
    end;
    
    w := 0;
//    writeln('+');
    for i := 0 to t1_count - 2 do
      w := w + area(p[t1[i]],p[t1[i+1]]);
//    writeln('-');
    for i := 0 to t2_count - 2 do
      w := w - area(p[t2[i]],p[t2[i+1]]);

    writeln(w:0:3);
  end;
end.