(*********************************************************
  Sparing: 6 listopada 2004
  Zadanie: G - Rozklad zajec
  Autor:   Wladyslaw Bodzek
*********************************************************)

{$MODE DELPHI}

const
  MAXN = 100000;
  
type
  point = record 
    t : Integer;
    w : Integer;
  end;
  
  List = array[0..2*MAXN] of point;

function psmaller( var p1, p2 : point ):Boolean;
begin
  Result := (p1.t < p2.t) or (p1.t = p2.t) and (p1.w < p2.w);
end;

procedure QuickSort(var A: List; Lo, Hi: longint);
  procedure Sort(l, r: longint);
    var
      i, j : Integer;
      x, y : point;
  begin
    i := l; j := r; x := a[(l+r) DIV 2];
    repeat
      while psmaller(a[i],x) do i := i + 1;
      while psmaller(x,a[j]) do j := j - 1;
      if i <= j then begin
        y := a[i]; a[i] := a[j]; a[j] := y;
        i := i + 1; j := j - 1;
      end;
    until i > j;
    if l < j then Sort(l, j);
    if i < r then Sort(i, r);
  end;
begin
  Sort(Lo,Hi);
end;

var
  nsets, iset, n, m, i, max, cur, a, b : Integer;
  d : List;
  
begin
  readln(nsets);
  for iset := 1 to nsets do begin
    readln(n,m);
    for i := 0 to n - 1 do begin
      readln(a,b);
      d[2*i].t   := a;
      d[2*i].w   := 1;
      d[2*i+1].t := b;
      d[2*i+1].w := -1;      
    end;
    QuickSort(d,0,2*n-1);
    max := 0;
    cur := 0;
    for i := 0 to 2*n - 1 do begin
      cur := cur + d[i].w;
      if cur > max then 
        max := cur;
      if max > m then 
        break;
    end;
    if max > m then 
      writeln('NIE')
    else
      writeln(m-max);
  end;
end.