/* roman.c */

#include <stdio.h>
#include <stdlib.h>

#define IN_FILE "PROBLEMG.DAT"
#define BUFF_SIZE 128
#define NUM_ELEMS 8


#define max(x, y) ((x) > (y) ? (x) : (y))
#define abs(i) ((i) > 0 ? (i) : (-i))

struct elem {
    char letter;
    long coeff;
    char non_zero;
} element[NUM_ELEMS];


    static void
add_coeff(char *num, int mult)
{
    long power;
    int i, ind;

    for (i = strlen(num) - 1, power = 1; i >= 0; i--, power *= 10) {
	for (ind = 0; element[ind].letter != num[i] &&
	              element[ind].letter != ' '; ind++) {
	    ;
	}
	if (element[ind].letter == ' ') {
	    element[ind].letter = num[i];
	    element[ind].coeff = 0;
	    element[ind].non_zero = 0;
	}
	element[ind].coeff += power * mult;
	if (i == 0) {
	    element[ind].non_zero = 1;
	}
    }
}


    static int
matches(int ind, int mask, long total)
{
    int i, ret_val;
    long val;

    if (element[ind+1].letter == ' ') {
	if ((total > 0 && element[ind].coeff > 0) ||
	    (total < 0 && element[ind].coeff < 0)) {
	    return 0;
	}
	if (element[ind].coeff == 0) {
	    return total == 0 ? 1 : 0;
	}
	if (abs(total) % abs(element[ind].coeff) != 0) {
	    return 0;
	}
	val = abs(total) / abs(element[ind].coeff);
	if ((val == 0 && element[ind].non_zero) || val > 9) {
	    return 0;
	}
	return ((1 << val) & mask) != 0;
    }

    ret_val = 0;
    for (i = element[ind].non_zero ? 1 : 0; i <= 9; i++) {
	if (((1 << i) & mask) != 0) {
	    ret_val += matches(ind + 1, mask & ~(1 << i),
			       total + element[ind].coeff * i);
	}
    }
    return ret_val;
}
							      

    static void
algebra(char *num1, char *num2, char *num3) 
{
    int len1 = max(strlen(num1), strlen(num2));
    int len2 = strlen(num3);
    int i;

    if (!(len1 == len2 || len1 + 1 == len2)) {
	printf("impossible\n");
	return;
    }
    for (i = 0; i < NUM_ELEMS; i++) {
	element[i].letter = ' ';
    }
    add_coeff(num1, 1);
    add_coeff(num2, 1);
    add_coeff(num3, -1);
    switch (matches(0, 0x3ff, 0)) {
      case 0: printf("impossible\n"); break;
      case 1: printf("valid\n"); break;
      default: printf("ambiguous\n"); break;
    }
}

static char last_char;

    static void
get_number(FILE *in_file, char *buffer)
{
    int i;

    for (i = 0; ; i++) {
	if ((last_char = fgetc(in_file)) == EOF) {
	    fprintf(stderr, "Error reading input\n");
	    exit(1);
	}
	if (isupper(last_char)) {
	    buffer[i] = last_char;
	} else if (last_char == '#') {
	    exit(0);
	} else {
	    break;
	}
    }
    buffer[i] = '\0';
}


    static void
skip_line(FILE *in_file)
{
    while (last_char != '\n' && last_char != EOF)  {
	last_char = fgetc(in_file);
    }
}

int conv_table[256];

    static void
init_table(void)
{
    conv_table['I'] = 1;
    conv_table['V'] = 5;
    conv_table['X'] = 10;
    conv_table['L'] = 50;
    conv_table['C'] = 100;
    conv_table['D'] = 500;
    conv_table['M'] = 1000;
}


    long
romantoi(char *roman)
{
    long res;

    for (res = 0; *roman; ) {
	if (roman[1] && conv_table[roman[0]] < conv_table[roman[1]]) {
	    res += conv_table[roman[1]] - conv_table[roman[0]];
	    roman += 2;
	} else {
	    res += conv_table[roman[0]];
	    roman++;
	}
    }
/*    printf("%ld ", res);*/
    return res;
}
	    

main()
{
    FILE *in_file;
    char buffer[BUFF_SIZE], a[BUFF_SIZE], b[BUFF_SIZE], c[BUFF_SIZE];
    
    long r1, r2, r3;
    char *cp;

    init_table();

/*    if ((in_file = fopen(IN_FILE, "r")) == 0) {
	fprintf(stderr, "Couldn't open file %s\n", IN_FILE);
	exit(1);
    } */
    in_file = stdin;
 
    for(;;) {
	get_number(in_file, a);
	get_number(in_file, b);
	get_number(in_file, c);
	skip_line(in_file);
	r1 = romantoi(a);
	r2 = romantoi(b);
	r3 = romantoi(c);
	if (r1 + r2 == r3) {
	    printf("Correct ");
	} else {
	    printf("Incorrect ");
	}
	algebra(a, b, c);
    }

    return 0;
}

