/*
	Problem: 	D: Wall
	Description:	find the convex hull and build a wall around it (in a given distance)
	Class:		2D geometry
	Subclass:	linear
	Algorithm:	convex hull of polygon entered in clockwise order O(n)
	Author:		Josef Zlomek
	Date:		Mar 9, 2002
*/

#include <stdio.h>
#include <math.h>

#define N 1000
#define EPSILON 0.0000000001
#define PI 3.1415926535

int n,dist,s;
int nn;

struct vertex{
  int x,y;
} v[N];

int uhel(int a,int b,int c)
{
  double u1,u2;

  u1=atan2(v[b].y-v[a].y,v[b].x-v[a].x);
  u2=atan2(v[c].y-v[a].y,v[c].x-v[a].x);

  if(fabs(u1-u2)<EPSILON)
    return 0;
  if (u1 < u2 && u2 < u1 + PI)
    return -1;
  u2+=2*PI;
  if (u1 < u2 && u2 < u1 + PI)
    return -1;
  return 1;
}

int main()
{
  int i;
  double len;
  int NN;
  scanf("%d",&NN);

  while(NN--)
  {
    if(scanf ("%d %d", &nn, &dist)!=2) break;

    n=0;
    for (i=0; i<nn;i++)
    {
      scanf ("%d %d",&v[n].x,&v[n].y);
      while(n>=2 && uhel(n,n-1,n-2)>0)
      {
	n--;
	v[n].x=v[n+1].x;
	v[n].y=v[n+1].y;
      }
      n++;
    }
    while(n>=2 && uhel(0,n-1,n-2)>0)
      n--;
    for(s=0;s<=n-2 && uhel(n-1,s,s+1)<0; s++);

    len = 0;
    for(i=s;i<n;i++)
    {
      int dx,dy,j;
      j=(i+1)%n;
      if(j==0) j+=s;
      dx=v[i].x-v[j].x;
      dy=v[i].y-v[j].y;
      len += sqrt (dx*dx+dy*dy);
    }
    len += PI*2*dist+0.5;
    printf("%d\n",(int)len);
  }
  return 0;
}
