/*
        Problem:        Brackets sequence
        Description:    extend given string of brackets to correct one
        Class:          compilers
        Subclass:       syntax anal.
        Algorithm:      dynamic programming O(n^3)
        Author:         Zdenek Dvorak
        Date:           Mar 11, 2002
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define REACH_SURROUND -1

#define MLEN 250

int cost[MLEN][MLEN];
int reach[MLEN][MLEN];

char bseq[MLEN];

#define MINIM(a,b,reach,val) \
 do\
  {\
   if (a>(b))\
    {\
    a=(b);\
    reach = val;\
    }\
  }\
 while (0)

int closing (char ch)
 {
  return (ch==')'||ch==']');
 }
int opening (char ch)
 {
  return (ch=='('||ch=='[');
 }
int matching (char o,char c)
 {
  return (o=='('&&c==')') || (o=='['&&c==']');
 }
char matchbr (char ch)
 {
  switch (ch)
   {
    case '(': return ')';
    case '[': return ']';
    case ')': return '(';
    case ']': return '[';
   }
  exit(1);
 }

int count_best (int od,int kk)
 {
  int m=2000000, plus=0, i, re;
  int o,k;
  if (cost[od][kk]>=0)
   return cost[od][kk];
  o = od;
  k = kk;
  while (o<k && closing(bseq[o])) { o++; plus++; }
  while (k>o && opening(bseq[k-1])) { k--; plus++; }
  if (cost[o][k]>=0)
   {
    m=cost[o][k];
    cost[od][kk]=m+plus;
    reach[od][kk]=reach[o][k];
    return m+plus; 
   }
  if (matching(bseq[o],bseq[k-1]))
   MINIM(m,count_best(o+1,k-1),re,REACH_SURROUND);
  for (i=o+1;i<k;i++)
   {
    int c1,c2,c;
    c1 = count_best(o,i);
    c2 = count_best(i,k);
    c=c1+c2;
    MINIM(m,c,re,i);
   }
  cost[o][k]=m;
  cost[od][kk]=m+plus;
  reach[o][k]=re;
  reach[od][kk]=re;
  return m+plus;
 }

void write_best(int od,int kk)
 {
  int o,k,i;
  if (od==kk)
   return;
  o=od;
  k=kk;
  while (o<k && closing(bseq[o])) o++;
  while (k>o && opening(bseq[k-1])) k--;
  for (i=o-1;i>=od;i--)
   putchar(matchbr(bseq[i]));
  for (i=od;i<o;i++)
   putchar(bseq[i]);
  if (o!=k)
   {
   if (reach[o][k]==REACH_SURROUND)
    {
     putchar(bseq[o]);
     write_best(o+1,k-1);
     putchar(bseq[k-1]);
    }
   else
    {
     write_best(o,reach[o][k]);
     write_best(reach[o][k],k);
    }
   }
  for (i=k;i<kk;i++)
   putchar(bseq[i]);
  for (i=kk-1;i>=k;i--)
   putchar(matchbr(bseq[i]));
 }

int main(void)
 {
 int i,j,l;
 int NN;
 scanf("%d",&NN);
 while (NN--)
  {
  if (scanf("%s",bseq)!=1)
   return 0;
  l=strlen(bseq);
  for (i=0;i<l;i++)
   for (j=i+1;j<=l;j++)
    cost[i][j]=-1;
  for (i=0;i<l;i++)
   cost[i][i]=0;
  count_best(0,l);
  write_best(0,l);
  putchar('\n');
  }
 }
