/*
        Problem:        Cable master
        Description:    cut as long cables as possible from given set
        Class:          numbers
        Subclass:       approximations
        Algorithm:      halving intervals O(n.log length)
        Author:         Zdenek Dvorak
        Date:           Mar 11, 2002
*/

#include <stdio.h>

int lens[20000];

int poflen(int l, int t)
 {
  int k,i;
  k=0;
  for (i=0; i<t; i++)
   k += lens[i]/l;
  return k;
 }

int countlen(int t, int k)
 {
  int l,h,m,i;
  int km;
  long long s;
  for (s=0,i=0;i<t;i++)
   s+=lens[i];
  h = s/k;
  l = s/(t+k-1);
  while (l!=h)
   {
    m = (l+h+1)/2;
    km = poflen(m,t);
    if (km < k)
     h = m - 1;
    else
     l = m;
   }
  return l;
 }

int main(void)
 {
  int n,k,i,l;
  int c,d;
  int NN;
  scanf("%d",&NN);
  while (NN--)
   {
    scanf("%d%d",&n,&k);
    for (i=0;i<n;i++)
     {
     scanf("%d.%d",&c,&d);
     lens[i]=100*c+d;
     }
    l=countlen(n,k);
    printf("%d.%02d\n",l/100,l%100);
   }
 }

