#include <cstdio>
#include <algorithm>
#include <functional>
using namespace std;

#define MAX_T 1000001

int T[MAX_T];
int A[20];
int n;

int gcd(int a, int b) {
	if (a == 0)
		return b;
	return gcd(b % a, a);
}

int dfs(int x) {
	T[x] = 1;

	for (int i=0; i<n; ++i) {
		if (x*A[i] < MAX_T && !T[x*A[i]])
			dfs(x * A[i]);
		if (x%A[i]==0 && !T[x/A[i]])
			dfs(x / A[i]);
	}
}

int main() {
	int t, m;
	scanf("%d", &t);
	for (int z=1; z<=t; ++z) {
		scanf("%d", &n);
		for (int i=0; i<n; ++i)
			scanf("%d", &A[i]);

		for (int i=0; i<MAX_T; ++i)
			T[i] = 0;

		int d = A[0];
		for (int i=0; i<n; ++i)
			d = gcd(d, A[i]);
		
		for (int i=0; i<n; ++i)
			A[i] /= d;

		dfs(1);

		//printf("Scenario #%d:\n", z);

		scanf("%d", &m);
		while (m--) {
			int a, b;

			scanf("%d%d", &a, &b);

			int d = gcd(a, b);

			if (T[a/d] && T[b/d])
				printf("TAK\n", a, b);
			else
				printf("NIE\n", a, b);
		}

		printf("\n");
	}
	return 0;
}
