#include <algorithm>
#include <cstdio>
#include <string>
#include <queue>
#include <utility>
using namespace std;

#define MAX_N 1000

struct word {
	string w;
	int p;
};

class node {
public:
	node();
	~node();

	void add(word & w, int k);
	node * go(int x);
	word & getWord();

	int p;
	word * max;
	node * N[26];
};

word W[MAX_N];
int A[9][5] = {
	{ 3,  0,  1,  2, },
	{ 3,  3,  4,  5, },
	{ 3,  6,  7,  8, },
	{ 3,  9, 10, 11, },
	{ 3, 12, 13, 14, },
	{ 4, 15, 16, 17, 18, },
	{ 3, 19, 20, 21, },
	{ 4, 22, 23, 24, 25, },
};

int main() {
	int t, n, q;
	scanf("%d", &t);

	for (int z=1; z<=t; ++z) {
		scanf("%d", &n);
        
		for (int i=0; i<n; ++i) {
			char str[1000];
			scanf("%s%d", str, &W[i].p);
			W[i].w = str;
		}

		node head;

		for (int i=0; i<n; ++i)
			head.add(W[i], 0);

		//for (int i=0; i<n; ++i)
		//	printf("%s %d\n", W[i].w.c_str(), W[i].p);

		scanf("%d", &q);
	//	printf("Scenario #%d:\n", z);

		for (int i=0; i<q; ++i) {
			char str[1000];
			scanf("%s", str);

			queue< pair<node *, int> > Q;
			Q.push(make_pair(&head, 0));

			for (int i=0; str[i] != '1'; ++i) {
				node * n = NULL;

				for (; !Q.empty() && Q.front().second==i;) {
					node * tmp = Q.front().first; Q.pop();
					node * tmp1;

                    int x = str[i]-'2';

					for (int j=1; j<=A[x][0]; ++j) {
						tmp1 = tmp->go(A[x][j]);
						if (tmp1) {
							Q.push(make_pair(tmp1, i+1));
							if (!n || n->p < tmp1->p || (n->p == tmp1->p && tmp1->getWord().w < n->getWord().w))
								n = tmp1;
						}
					}
				}

				if (n) {
					char str2[1000];
					strcpy(str2, n->getWord().w.c_str());
					str2[i+1] = 0;
					printf("%s\n", str2);
				} else {
					printf("RECZNIE\n");
					for (i++; str[i] != '1'; ++i)
						printf("RECZNIE\n");
					break;
				}
			}
			printf("\n");
		}
		printf("\n");
	}

	return 0;
}

node::node() {
	p = 0;
    max = NULL;

	for (int i=0; i<26; ++i)
		N[i] = NULL;
}

node::~node() {
	for (int i=0; i<26; ++i)
		if (N[i])
			delete N[i];
}

void node::add(word & w, int k) {
	int x = w.w[k]-'a';

	max = &w;
	p += w.p;

	if (k == w.w.length())
		return;

	if (N[x] == NULL)
		N[x] = new node();

	N[x]->add(w, k+1);
}

node * node::go(int x) {
	return N[x];
}

word & node::getWord() {
	return * max;
}
