/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie pomocnicze do zadania C - Dom towarowy
 * Zlozonosc: O(N^2+suma_dlug_list*(N+log(sum_dlug_list)))
 * (rozwiazanie wolne, ale prostsze ideologicznie)
 *
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#include <stdlib.h>
#define NDEBUG
#include <assert.h>

/*#define WORSEDYNAMIC*/


#define INF 2100000000

#define MAXN 2500
#define MAXM 1000
#define MAXT 500
#define MAXLIST 75000


int N, M;
int TE, TF, TS;

int Lbase[MAXLIST];
int *L[MAXM];
int lc[MAXM];

struct STALL
{
  int stall, prev;
} S[MAXLIST];
int sc;

int C[MAXN][MAXN];
#ifdef WORSEDYNAMIC
int T[MAXN][MAXN];
#else
int T[MAXN];
#endif


int cmp(const void *a, const void *b)
{
  struct STALL *sa = (struct STALL*)a, *sb = (struct STALL*)b;

  if (sa->stall < sb->stall) return -1;
  if (sa->stall > sb->stall) return 1;
  return 0;
}


int main()
{
  int D;
  int pos;
  int sum;
  int i, j;
#ifdef WORSEDYNAMIC
  int min;
  int k;
#endif
  

  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));
  
  while (D--)
  {
    if (scanf("%d%d", &N, &M) < 2)
      assert(0);
    assert((N >= 1) && (N <= MAXN));
    assert((M >= 1) && (M <= MAXM));
    if (scanf("%d%d%d", &TE, &TF, &TS) < 3)
      assert(0);
    assert((TE >= 0) && (TE <= MAXT));
    assert((TF >= 0) && (TF <= MAXT));
    assert((TS >= 0) && (TS <= MAXT));
    
    sc = 0;
    for (i = 0; i < M; i++)
    {
      if (scanf("%d", &lc[i]) < 1)
        assert(0);
      assert((lc[i] >= 1) && (lc[i] <= N));
      L[i] = Lbase+sc;
      for (j = 0; j < lc[i]; j++)
      {
        int val;
        if (scanf("%d", &val) < 1)
          assert(0);
        assert((val >= 1) && (val <= N));
        --val;
        L[i][j] = val;
        assert((0 == j) || (L[i][j] > L[i][j-1]));
        S[sc+j].stall = val;
        S[sc+j].prev = (j > 0) ? L[i][j-1] : -1;
      }
      sc += lc[i];
      assert(sc <= MAXLIST);
    }
    qsort(S, sc, sizeof(struct STALL), cmp);

    for (i = 0; i < N; i++)
    {
      pos = 0;
      while ((pos < sc) && (S[pos].stall < i))
        pos++;
      sum = 0;
      for (j = i; j < N; j++)
      {
        while ((pos < sc) && (S[pos].stall == j))
        {
          if (S[pos].prev < i)
          {
            sum += TE+(S[pos].stall-i)*TF;
          }
          else
          {
            sum += (S[pos].stall-S[pos].prev)*TF;
          }
          pos++;
        }
        C[j][i] = sum;
      }
      assert(pos == sc);
    }

#ifdef WORSEDYNAMIC
    for (j = 0; j < N; j++)
      T[0][j] = C[j][0];
    min = T[0][N-1];
    for (i = 1; i < N; i++)
    {
      for (j = i; j < N; j++)
      {
        T[i][j] = INF;
        for (k = i; k <= j; k++)
        {
          assert((long long)T[i-1][k-1]+C[j][k] < INF);
          if (T[i-1][k-1]+C[j][k] < T[i][j])
            T[i][j] = T[i-1][k-1]+C[j][k];
        }
      }
      if (T[i][N-1] < min)
      {
        min = T[i][N-1];
      }
    }
    printf("%d\n", min+sc*TS);
#else
    for (i = 0; i < N; i++)
    {
      T[i] = C[i][0];
      for (j = 0; j < i; j++)
      {
        assert((long long)T[j]+C[i][j+1] < INF);
        if (T[j]+C[i][j+1] < T[i])
          T[i] = T[j]+C[i][j+1];
      }
    }
    printf("%d\n", T[N-1]+sc*TS);
#endif
  }

  return 0;
}
