/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania D - Akwarium
 * Zlozonosc: O(W*log(W))
 * 
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#include <stdlib.h>
#define NDEBUG
#include <assert.h>

#define MAXH 10000000
#define MAXW 30000
#define MAXL 1000000000


int A[MAXW+1];
int W, H;
int L;


int cmp(const void *a, const void *b)
{
  if ((*(int*)a) < (*(int*)b)) return -1;
  if ((*(int*)a) > (*(int*)b)) return 1;
  return 0;
}


int main()
{
  int D;
  double delta;
  int i;
#ifndef NDEBUG
  int _ok;
#endif


  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));

  while (D--)
  {
    if (scanf("%d%d%d", &W, &H, &L) < 3)
      assert(0);
    assert((W >= 1) && (W <= MAXW));
    assert((H >= 1) && (H <= MAXH));
    assert((L >= 1) && (L <= MAXL));
#ifndef NDEBUG
    _ok = 0;
#endif
    for (i = 0; i < W; i++)
    {
      if (scanf("%d", &A[i]) < 1)
        assert(0);
      assert((A[i] >= 1) && (A[i] <= H));
#ifndef NDEBUG
      if (A[i] < H)
        _ok = 1;
#endif
    }
    assert(_ok);
    A[W] = H;
    ++W;

    qsort(A, W, sizeof(int), cmp);

    delta = 0.0;
    for (i = 1; i < W; i++)
    {
      if (A[i-1]+(L+i-1)/i <= A[i])
      {
        delta = (double)L/(double)i;
        break;
      }
      else
      {
        L -= (A[i]-A[i-1])*i;
      }
    }

    assert(A[i-1]+delta <= H+0.000000001);
    printf("%.5f\n", A[i-1]+delta);
  }

  return 0;
}

