/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania F - Pakowanie plecaka
 * Zlozonosc: O(N*(M+logN))
 * 
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#include <stdlib.h>
#define NDEBUG
#include <assert.h>


#define INF 2100000000

#define MAXN 1000
#define MAXM 8000
#define MAXVAL 1000000



int N, M;
int T[MAXM+1];
struct ELEM
{
  int w;
  int v;
} E[MAXN];


int cmp(const void *a, const void *b)
{
  struct ELEM *ea = (struct ELEM*)a, *eb = (struct ELEM*)b;

  if (ea->w > eb->w) return -1;
  if (ea->w < eb->w) return 1;
  return 0;
}


int main()
{
  int D;
  int sumv, max;
  int sumw;
  int i, j;
  
  
  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));

  while (D--)
  {
    if (scanf("%d%d", &N, &M) < 2)
      assert(0);
    assert((N >= 1) && (N <= MAXN));
    assert((M >= 1) && (M <= MAXM));
    for (i = 0; i < N; i++)
    {
      if (scanf("%d%d", &E[i].w, &E[i].v) < 2)
        assert(0);
      assert((E[i].w >= 1) && (E[i].w <= M));
      assert((E[i].v >= -MAXVAL) && (E[i].v <= MAXVAL));
    }

    qsort(E, N, sizeof(struct ELEM), cmp);
#ifndef NDEBUG
    for (i = 1; i < N; i++)
      assert(E[i-1].w >= E[i].w);
#endif

    sumw = 0;
    sumv = 0;
    for (i = 0; i < N; i++)
    {
      sumw += E[i].w;
      sumv += E[i].v;
    }
    max = -INF;
    if (sumw <= M)
      max = sumv;
    
    for (j = 1; j <= M; j++)
      T[j] = -INF;
    T[0] = 0;
    for (i = 0; i < N; i++)
    {
      sumw -= E[i].w;
      sumv -= E[i].v;
      j = M-sumw-E[i].w+1;
      if (j < 0)
        j = 0;
      for (; j <= M-sumw; j++)
      {
        if ((-INF != T[j]) && (T[j]+sumv > max))
          max = T[j]+sumv;
      }
      
      for (j = M; j >= 0; j--)
      {
        if ((j-E[i].w >= 0) && (-INF != T[j-E[i].w]) && (T[j-E[i].w]+E[i].v > T[j]))
          T[j] = T[j-E[i].w]+E[i].v;
      }
    }

    printf("%d\n", max);
  }
  

  return 0;
}
