(*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania G - Statysci
 * Zlozonosc: O(N*logN)
 *
 * Autor programu: Wladyslaw Bodzek
 *)

{$R-}
type
 candidate = packed record
  no : Word;
  conv_time : Word;
  ratio : Word;
 end;
var
 D, N : LongInt;
 t : array[0..30000] of candidate;
 s : array[0..30000] of Word;
 i, j : LongInt;

function cmp( a, b : Word ):LongInt;
 var
  val : LongInt;
begin
 val := LongInt(t[s[b]].ratio) * LongInt(t[s[a]].conv_time)
      - LongInt(t[s[a]].ratio) * LongInt(t[s[b]].conv_time);
 if val = 0 then
  val := t[s[a]].no - t[s[b]].no;
 cmp := val;
end;


function partition( a, b : LongInt ):LongInt;
 var
  x : LongInt;
  i, j : LongInt;
  tt : LongInt;
begin
 x := a + random(b-a+1);
 i := a - 1;
 j := b + 1;
 while true do begin
  repeat dec(j) until cmp(j,x) <= 0;
  repeat inc(i) until cmp(i,x) >= 0;
  if i < j then begin
   tt := s[i]; s[i] := s[j]; s[j] := tt;
   if i = x then x := j
   else if j = x then x := i;
  end else begin
   partition := j;
   break;
  end;
 end; 
end;

procedure qsort( a, b : LongInt );
 var 
  q : LongInt;
begin
 if a < b then begin
  q := partition(a,b);
  qsort(a,q);
  qsort(q+1,b); 
 end;
end;



begin
 readln(D);
 while D > 0 do begin
  readln(N);
  for i := 0 to N - 1 do
   read(t[i].conv_time);
  for i := 0 to N - 1 do
   read(t[i].ratio);
  for i := 0 to N - 1 do begin
   s[i] := i;
   t[i].no := i;
  end;
  s[30000] := 30000;
   
  qsort(0,N-1);
  
  for i := 0 to N - 2 do 
   write(s[i]+1,' ');
  writeln(s[N-1]+1); 
  
  dec(D);
 end;
end.
