/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania A - Kryminal
 * Zlozonosc: O((N+M)*log(max_inteligencja))
 * 
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#define NDEBUG
#include <assert.h>


#define MAXN 10000
#define MAXM 30000
#define MAXI 1000000000


int N, M;

struct PAIR
{
  int A, B;
  int x, y;
} pairs[MAXM];

struct ARC
{
  int d;
  int v;
} Gbase[MAXM*2];
struct ARC *G[MAXN];
int gc[MAXN];


int U[MAXN];
int intelig;
int O[MAXN];
int oc;


int DFS(int no)
{
  int i;

  if (1 == U[no])
    return 1;
  if (2 == U[no])
    return 0;
  assert(0 == U[no]);
  ++U[no];
  for (i = 0; i < gc[no]; i++)
    if ((G[no][i].v <= intelig) && DFS(G[no][i].d))
      return 1;
  ++U[no];
  assert(2 == U[no]);
  O[oc++] = no;
  return 0;
}


int topsort()
{
  int i;
  
  for (i = 0; i < N; i++)
    U[i] = 0;
  oc = 0;
  for (i = 0; i < N; i++)
    if (!U[i])
      if (DFS(i))
        return 0;
  assert(oc == N);
  return 1;
}


int main()
{
  int D;
  int i;
  int pos;
  int A, B;
  int x, y;
  int mini, maxi, midi;
#ifndef NDEBUG
  int _U[MAXN], _S[MAXN];
  int _sc;
  int _j;
#endif


  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));

  while (D--)
  {
    if (scanf("%d%d", &N, &M) < 2)
      assert(0);
    assert((N >= 2) && (N <= MAXN));
    assert((M >= 1) && (M <= MAXM));

    for (i = 0; i < N; i++)
      gc[i] = 0;
  
    mini = MAXI+1;
    maxi = -1;
    for (i = 0; i < M; i++)
    {
      if (scanf("%d%d%d%d", &A, &B, &x, &y) < 4)
      {
        assert(0);
      }
      --A;
      --B;
      assert((A >= 0) && (A < N));
      assert((B >= 0) && (B < N));
      assert((A != B));
      assert((x >= 0) && (x <= MAXI));
      assert((y >= 0) && (y <= MAXI));

      ++gc[A];
      ++gc[B];
      if (x > maxi)
        maxi = x;
      if (y > maxi)
        maxi = y;
      if (x < mini)
        mini = x;
      if (y < mini)
        mini = y;
      pairs[i].A = A;
      pairs[i].B = B;
      pairs[i].x = x;
      pairs[i].y = y;
    }
    pos = 0;
    for (i = 0; i < N; i++)
    {
      assert(gc[i] < N);
      G[i] = Gbase+pos;
      pos += gc[i];
      gc[i] = 0;
    }
    assert(2*M == pos);
    
    for (i = 0; i < M; i++)
    {
      A = pairs[i].A;
      B = pairs[i].B;
      x = pairs[i].x;
      y = pairs[i].y;
      
      G[A][gc[A]].d = B;
      G[A][gc[A]].v = y;
      gc[A]++;
      G[B][gc[B]].d = A;
      G[B][gc[B]].v = x;
      gc[B]++;
    }
#ifndef NDEBUG
    for (_j = 0; _j < N; _j++)
      _U[_j] = 0;
    for (i = 0; i < N; i++)
    {
      _sc = 0;
      for (_j = 0; _j < gc[i]; _j++)
      {
        assert(!_U[G[i][_j].d]);
        _U[G[i][_j].d] = 1;
        _S[_sc++] = G[i][_j].d;
      }
      while (_sc)
        _U[_S[--_sc]] = 0;
    }
#endif

    mini--;
    while (mini < maxi)
    {
      midi = (mini+maxi+1)/2;
      intelig = midi;
      if (topsort())
      {
        mini = midi;
      }
      else
      {
        maxi = midi-1;
      }
    }
    assert(mini == maxi);
#ifndef NDEBUG
    intelig = mini+1;
    assert(!topsort());
    intelig = mini;
    assert(topsort());
#endif
    intelig = mini;
    topsort();

#ifndef NDEBUG
    for (_j = 0; _j < N; _j++)
      _U[_j] = 0;
    for (_j = 0; _j < gc[i]; _j++)
    {
      assert(!_U[O[_j]]);
      _U[O[_j]] = 1;
    }
#endif
    printf("%d", mini+1);
    for (i = N-1; i >= 0; i--)
      printf(" %d", O[i]+1);
    printf("\n");
  }


  return 0;
}
