(*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania A - Kryminal
 * Zlozonosc: O(M*log(M)+N)
 *
 * Autor programu: Wladyslaw Bodzek
 *)

{$R-}
type
 rule = packed record
  a, b : Word;
  w : LongInt;
 end;
 vertex = packed record
  incoming : LongInt;
  last : LongInt;
 end;
 edge = packed record
  target : Word;
  weight : LongInt;
  next : LongInt;
 end;

var
 D, N, M : LongInt;
 i, a, b, x, y : LongInt;
 r : array[0..60000] of rule;
 r_count : LongInt;

function partition( a, b : LongInt ):LongInt;
 var
  x : LongInt;
  i, j : LongInt;
  t : rule;
begin
 x := r[a + random(b-a+1)].w;
 i := a - 1;
 j := b + 1;
 while true do begin
  repeat dec(j) until r[j].w <= x;
  repeat inc(i) until r[i].w >= x;
  if i < j then begin
   t := r[i]; r[i] := r[j]; r[j] := t;
  end else begin
   partition := j;
   break;
  end;
 end; 
end;

procedure qsort( a, b : LongInt );
 var 
  q : LongInt;
begin
 if a < b then begin
  q := partition(a,b);
  qsort(a,q);
  qsort(q+1,b); 
 end;
end;

procedure sort_rules;
begin
 qsort(0,r_count-1);
end;

 
 
 
var
 v : array[0..10000] of vertex;
 e : array[0..80000] of edge;
 e_count : LongInt;
 w : array[0..10000] of LongInt;
 wst, wend : LongInt;


procedure reset_graph;
 var
  i : LongInt;
begin
 for i := 0 to N - 1 do begin
  v[i].incoming := 0;
  v[i].last := i;
 end;
 wst := 0;
 wend := 0;
 e_count := N;
end;

procedure add_edge( a, b, w : LongInt );
begin
 e[v[a].last].next := e_count;
 v[a].last := e_count;
 e[v[a].last].target := b;
 e[v[a].last].weight := w;
 inc(e_count);
 inc(v[b].incoming);
end;

procedure del_first_edge( a : LongInt );
 var
  b : LongInt;
begin
 if a = v[a].last then
  halt(1);
 b := e[e[a].next].target;
 dec(v[b].incoming);
 if v[b].incoming = 0 then begin
  w[wend] := b;
  inc(wend);
 end;
 if e[a].next = v[a].last then begin
  v[a].last := a
 end else
  e[a].next := e[e[a].next].next;
end;

procedure flush_vertexes;
 var
  a : LongInt;
begin
 while wst <> wend do begin
  a := w[wst];
  while a <> v[a].last do
   del_first_edge(a);
  inc(wst);
 end;
end;

procedure find_good_vertexes;
 var
  a : LongInt;
begin
 for a := 0 to N - 1 do
  if v[a].incoming = 0 then  begin
   w[wend] := a;
   inc(wend);
  end;
end;

begin
 readln(D);
 while D <> 0 do begin
  readln(N,M);
  r_count := 0;
  for i := 0 to M - 1 do begin
   readln(a,b,x,y);
   dec(a);
   dec(b);
   r[r_count].a := a;
   r[r_count].b := b;
   r[r_count].w := y;
   inc(r_count);
   r[r_count].a := b;
   r[r_count].b := a;
   r[r_count].w := x;
   inc(r_count);
  end;
  sort_rules;

  reset_graph;
  for i := r_count - 1 downto 0 do
   add_edge(r[i].a,r[i].b,r[i].w);
  find_good_vertexes;
  flush_vertexes;
  i := r_count - 1;
  while wend <> N do begin
   if v[r[i].a].incoming <> 0 then
    del_first_edge(r[i].a);
   flush_vertexes;
   dec(i);
  end;

  write(r[i+1].w);
  for i := 0 to N - 1 do
   write(' ',w[i]+1);
  writeln;

  dec(D);
 end;
end.
