/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania C - Dom towarowy
 * Zlozonosc: O(N^2+suma_dlugosci_list)
 *
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#define NDEBUG
#include <assert.h>


#define INF 2100000000

#define MAXN 2500
#define MAXM 1000
#define MAXT 500
#define MAXLIST 75000


int N, M;
int TE, TF, TS;

int Lbase[MAXLIST];
int *L[MAXM];
int lc[MAXM];

struct STALL
{
  int stall, prev;
} stalls[MAXLIST];
int Sbase[MAXLIST];
int SC;
int *S[MAXN];
int sc[MAXN];

int C[MAXN][MAXN];
int T[MAXN];


int main()
{
  int D;
  int pos;
  int i, j, k;
  int cnt, sum;
  int P[MAXN];
  

  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));
  
  while (D--)
  {
    if (scanf("%d%d", &N, &M) < 2)
      assert(0);
    assert((N >= 1) && (N <= MAXN));
    assert((M >= 1) && (M <= MAXM));
    if (scanf("%d%d%d", &TE, &TF, &TS) < 3)
      assert(0);
    assert((TE >= 0) && (TE <= MAXT));
    assert((TF >= 0) && (TF <= MAXT));
    assert((TS >= 0) && (TS <= MAXT));
    
    SC = 0;
    for (i = 0; i < N; i++)
      sc[i] = 0;
    for (i = 0; i < M; i++)
    {
      if (scanf("%d", &lc[i]) < 1)
        assert(0);
      assert((lc[i] >= 1) && (lc[i] <= N));
      L[i] = Lbase+SC;
      for (j = 0; j < lc[i]; j++)
      {
        int val;
        if (scanf("%d", &val) < 1)
          assert(0);
        assert((val >= 1) && (val <= N));
        --val;
        L[i][j] = val;
        assert((0 == j) || (L[i][j] > L[i][j-1]));
        stalls[SC+j].stall = val;
        stalls[SC+j].prev = (j > 0) ? L[i][j-1] : -1;
        ++sc[val];
      }
      SC += lc[i];
      assert(SC <= MAXLIST);
    }
    pos = 0;
    for (i = 0; i < N; i++)
    {
      S[i] = Sbase+pos;
      pos += sc[i];
      sc[i] = 0;
    }
    assert(pos == SC);
    for (i = 0; i < SC; i++)
    {
      int stall = stalls[i].stall;
      S[stall][sc[stall]] = stalls[i].prev;
      ++sc[stall];
    }

    for (i = 0; i < N; i++)
    {
      for (j = 0; j < i; j++)
        P[j] = 0;
      for (j = 0; j < sc[i]; j++)
      {
        if (S[i][j] >= 0)
          ++P[S[i][j]];
      }
        
      cnt = sc[i];
      C[i][i] = sc[i]*TE;
      sum = sc[i]*TE;
      k = 0;
      for (j = i-1; j >= 0; j--)
      {
        sum += cnt*TF;
        cnt -= P[j];
        sum -= P[j]*TE;
        C[i][j] = C[i-1][j]+sum;
      }
    }

    for (i = 0; i < N; i++)
    {
      T[i] = C[i][0];
      for (j = 0; j < i; j++)
      {
        assert((long long)T[j]+C[i][j+1] < INF);
        if (T[j]+C[i][j+1] < T[i])
          T[i] = T[j]+C[i][j+1];
      }
    }

    printf("%d\n", T[N-1]+SC*TS);
  }

  return 0;
}
