(*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania D - Akwarium
 * Zlozonosc: O(W*log(W))
 *
 * Autor programu: Wladyslaw Bodzek
 *)

{$R-}
var
 D, W, H, L, i : LongInt;
 v : array[0..30000] of LongInt;
 res : double;
 sum : QWord;

function partition( a, b : LongInt ):LongInt;
 var
  x : LongInt;
  i, j : LongInt;
  t : LongInt;
begin
 x := v[a + random(b-a+1)];
 i := a - 1;
 j := b + 1;
 while true do begin
  repeat dec(j) until v[j] <= x;
  repeat inc(i) until v[i] >= x;
  if i < j then begin
   t := v[i]; v[i] := v[j]; v[j] := t;
  end else begin
   partition := j;
   break;
  end;
 end;
end;

procedure qsort( a, b : LongInt );
 var
  q : LongInt;
begin
 if a < b then begin
  q := partition(a,b);
  qsort(a,q);
  qsort(q+1,b);
 end;
end;

begin
 readln(D);
 while D <> 0 do begin
  readln(W,H,L);
  for i := 0 to W - 1 do
   readln(v[i]);
  v[W] := H;
  qsort(0,W);

  sum := 0;
  res := H;
  for i := 1 to W do begin
   if sum + QWord(v[i]-v[i-1])*QWord(i) < QWord(L) then
    sum := sum + (v[i]-v[i-1])*i
   else begin
    res := v[i-1] + (double(L-sum)/double(i));
    break;
   end;
  end;

  writeln(res:0:5);

  dec(D);
 end;
end.
