(*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania F - Pakowanie plecaka
 * Zlozonosc: O(N*M)
 *
 * Autor programu: Wladyslaw Bodzek
 *)

{$R-}
const 
 MAXN 		= 1000;
 MAXM		= 8000;
 NOWAY		= -2000000000;

type
 r_t = packed record
  w : LongInt;
  v : LongInt;
 end;
var
 D, N, M : LongInt;
 t : array[0..MAXN] of r_t;
 p : array[0..MAXM] of LongInt;
 i, j, k, sumw, sumv : LongInt;
 max : LongInt;

function partition( p, r : LongInt ):LongInt;
 var
  x : LongInt;
  i, j : LongInt;
  tt : r_t;
begin
 x := t[p + random(r-p+1)].w;
 i := p - 1;
 j := r + 1;
 while true do begin
  repeat dec(j) until t[j].w <= x;
  repeat inc(i) until t[i].w >= x;
  if i < j then begin
   tt := t[i]; t[i] := t[j]; t[j] := tt;
  end else begin
   partition := j;
   break;
  end;
 end;
end;

procedure qsort( p, r : LongInt );
 var
  q : LongInt;
begin
 if p < r then begin
  q := partition(p,r);
  qsort(p,q);
  qsort(q+1,r);
 end;
end;

begin
 readln(D);
 while D <> 0 do begin
  readln(N,M);
  sumw := 0;
  sumv := 0;
  for i := 0 to N - 1 do begin
   readln(t[i].w,t[i].v);
   sumw := sumw + t[i].w;
   sumv := sumv + t[i].v;
  end;

  if N = 1 then
   writeln(t[0].v)
  else begin
   max := NOWAY;
   qsort(0,N-1);
   for i := 0 to M do
    p[i] := NOWAY;
   p[0] := 0;
   if (sumv > max) and (sumw <= M) then
    max := sumv;
   sumw := sumw - t[N-1].w;
   sumv := sumv - t[N-1].v;
   if (sumv > max) and (sumw <= M) then
    max := sumv;
   for i := N - 2 downto 0 do begin
    sumw := sumw - t[i].w;
    sumv := sumv - t[i].v;
    for j := M downto t[i+1].w do
     if (p[j-t[i+1].w] <> NOWAY) and (p[j-t[i+1].w]+t[i+1].v>p[j]) then
      p[j] := p[j-t[i+1].w]+t[i+1].v;
    k := M-sumw-t[i].w+1;
    if k < 0 then
     k := 0;
    for j := k to M-sumw do begin
     if p[j] <> NOWAY then
      if sumv+p[j] > max then
       max := sumv+p[j];
    end;
   end;
   writeln(max);
  end;

  dec(D);
 end;
end.
