/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania G - Statysci
 * Zlozonosc: O(N*logN)
 * 
 * Autor programu: dr inz. Grzegorz Waligora
 */

#include <stdio.h>
#include <stdlib.h>
#define NDEBUG
#include <assert.h>

typedef unsigned int word;

#define maxn 30000
#define maxdur 10000
#define maxw 10000

typedef word       vector[maxn];
typedef struct srate {
  double rate;
  int no;
} vectord[maxn];

word          number_of_cases,n;
vector        duration_table,
              weight_table,
              order;
vectord       rate_table;

int greater (const void *a, const void *b) {
   if (((struct srate*)a)->rate < ((struct srate*)b)->rate)
      return -1;
   else
      if (((struct srate*)a)->rate > ((struct srate*)b)->rate)
         return 1;
      else
         if (((struct srate*)a)->no < ((struct srate*)b)->no)
            return -1;
         else
            if (((struct srate*)a)->no > ((struct srate*)b)->no)
               return 1;
            else
               return 0; }

void read_data (void) {
word i;
   if (scanf("%u",&n) < 1)
     assert(0);
   assert((n >= 1) && (n <= maxn));
   for (i=0; i<n; i++) {
      if (scanf("%u",&duration_table[i]) < 1)
        assert(0);
      assert((duration_table[i] >= 1) && (duration_table[i] <= maxdur)); }
   for (i=0; i<n; i++) {
      if (scanf("%u",&weight_table[i]) < 1)
        assert(0);
      assert((weight_table[i] >= 1) && (weight_table[i] <= maxw)); } }

void wspt (void) {
word i;
   for (i=0; i<n; i++) {
      rate_table[i].rate=((double)duration_table[i]/weight_table[i]);
      rate_table[i].no=i; }
   qsort(rate_table,n,sizeof(struct srate),greater); }

void results (void) {
word i;
   for (i=0; i<n; i++)
      printf((i < n-1) ? "%u ":"%u\n",rate_table[i].no+1); }

int main() {
word i;
   if (scanf("%u",&number_of_cases) < 1)
     assert(0);
   assert((number_of_cases > 0) && (number_of_cases <= 50));
   for (i=0; i<number_of_cases; i++) {
      read_data();
      wspt();
      results(); } 
   return 0; }
