/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania H - Taxi
 * Zlozonosc: O(N)
 * 
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#define NDEBUG
#include <assert.h>


#define MAXN 40000
#define MAXV 1000000



int main()
{
  int D;
  int N, i;
  int min1, min2, max1, max2;
  int x, y;


  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));

  while (D--)
  {
    if (scanf("%d", &N) < 1)
      assert(0);
    assert((N >= 2) && (N <= MAXN));

    min1 = 2*MAXV+1;
    max1 = -1;
    min2 = MAXV+1;
    max2 = -MAXV-1;
    for (i = 0; i < N; i++)
    {
      if (scanf("%d%d", &x, &y) < 2)
        assert(0);
      assert((x >= 0) && (x <= MAXV));
      assert((y >= 0) && (y <= MAXV));
      if (x+y > max1)
        max1 = x+y;
      if (x+y < min1)
        min1 = x+y;
      if (x-y > max2)
        max2 = x-y;
      if (x-y < min2)
        min2 = x-y;
    }
    max1 -= min1;
    max2 -= min2;
    if (max2 > max1)
      max1 = max2;
    assert((max1 >= 0) && (max1 <= 2*MAXV));
    printf("%d\n", max1);
  }

  return 0;
}
