/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Rozwiazanie wzorcowe do zadania I - Strajk
 * Zlozonosc: O(N*(N+M)+suma_dlug_linii*log(sum_dlug_linii))
 * 
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
#include <stdlib.h>
#define NDEBUG
#include <assert.h>


#define MAXN 1000
#define MAXM 1000
#define MAXLIST 150000
#define MAXT 1000000000



int N;
int M;
int SRC, DST;
int Strike[MAXN];
int Tracks[MAXN], Tracks2[MAXN];

int LineCities[MAXM][MAXN];
int LineTimes[MAXM][MAXN];
int lcnt[MAXM];
int LineBlocked[MAXM], LineBlocked2[MAXM];

struct MOVE
{
  int lno;
  int tbeg, tend;
  int src, dst, next;
} Moves[MAXLIST];
int mcnt;



struct ARC
{
  int tbeg, tend;
  int dst;
} G[MAXN][MAXM];
int gcnt[MAXN];

int CityTime[MAXN];
int Used[MAXN];


int CityLines[MAXN][MAXN];
int CityBlockedOn[MAXN];
int ccnt[MAXN];
int InCity[MAXM];
int S_CL[MAXN];
int s_cl_cnt;


void BlockLine(int no);

void BlockCity(int no)
{
  int i;

  assert(Tracks[no] >= 0);
  if (Tracks[no] <= 0)
    return;
  --Tracks[no];
  if (Tracks[no] <= 0)
  {
    for (i = 0; i < ccnt[no]; i++)
      BlockLine(CityLines[no][i]);
  }
}

void BlockLine(int lno)
{
  if (LineBlocked[lno])
    return;
  LineBlocked[lno] = 1;
  BlockCity(InCity[lno]);
}



int travelcmp(const void *a, const void *b)
{
  struct MOVE *ma = (struct MOVE*)a, *mb = (struct MOVE*)b;

  if (ma->tend < mb-> tend) return -1;
  if (ma->tend > mb-> tend) return 1;
  if (ma->lno < mb->lno) return -1;
  if (ma->lno > mb->lno) return 1;
  return 0;
}



int main()
{
  int D;
  int i, j, k;
#ifndef NDEBUG
  int _U[MAXN];
#endif

  
  if (scanf("%d", &D) < 1)
    assert(0);
  assert((D > 0) && (D <= 50));

  while (D--)
  {
    if (scanf("%d%d%d%d", &N, &M, &SRC, &DST) < 4)
      assert(0);
    SRC--;
    DST--;
    assert((N >= 2) && (N <= MAXN));
    assert((M >= 1) && (M <= MAXM));
    assert((SRC >= 0) && (SRC < N));
    assert((DST >= 0) && (DST < N));
    assert(SRC != DST);
    for (i = 0; i < N; i++)
    {
      if (scanf("%d%d", &Tracks[i], &Strike[i]) < 2)
        assert(0);
      assert((Tracks[i] >= 1) && (Tracks[i] <= MAXM));
      assert((Strike[i] >= -1) && (Strike[i] <= MAXT));
      if (-1 == Strike[i])
        Strike[i] = MAXT+1;
    }
    mcnt = 0;
    for (i = 0; i < M; i++)
    {
      if (scanf("%d", &lcnt[i]) < 1)
        assert(0);
      assert((lcnt[i] >= 2) && (lcnt[i] <= N));
#ifndef NDEBUG
      for (j = 0; j < N; j++)
        _U[j] = 0;
#endif
      for (j = 0; j < lcnt[i]; j++)
      {
        if (scanf("%d%d", &LineCities[i][j], &LineTimes[i][j]) < 2)
          assert(0);
        LineCities[i][j]--;
        assert((LineCities[i][j] >= 0) && (LineCities[i][j] < N));
#ifndef NDEBUG
        assert(!_U[LineCities[i][j]]);
        _U[LineCities[i][j]] = 1;
#endif
        assert((LineTimes[i][j] >= 0) && (LineTimes[i][j] <= MAXT));
        assert((0 == j) || (LineTimes[i][j] > LineTimes[i][j-1]));
        Moves[mcnt].lno = i;
        Moves[mcnt].tend = LineTimes[i][j];
        Moves[mcnt].dst = LineCities[i][j];
        Moves[mcnt].next = -1;
        if (j > 0)
        {
          Moves[mcnt].tbeg = LineTimes[i][j-1];
          Moves[mcnt].src = LineCities[i][j-1];
          assert(mcnt > 0);
          Moves[mcnt-1].next = LineCities[i][j];
        }
        else
        {
          Moves[mcnt].tbeg = -1;
          Moves[mcnt].src = -1;
        }
        ++mcnt;
        assert((mcnt <= MAXLIST) && (mcnt <= N*M));
      }
    }

    qsort(Moves, mcnt, sizeof(struct MOVE), travelcmp);

    for (i = 0; i < N; i++)
    {
      gcnt[i] = 0;
      ccnt[i] = 0;
    }
    s_cl_cnt = 0;
    for (i = 0; i < M; i++)
      LineBlocked[i] = 0;

    for (i = 0; i < mcnt; i++)
    {
      int tend = Moves[i].tend;
      int src, dst, next;
      int lno;

 
      j = i;
      while ((j < mcnt) && (Moves[j].tend <= Moves[i].tend))
      {
        assert(tend == Moves[j].tend);
        dst = Moves[j].dst;
        lno = Moves[j].lno;
        if ((-1 == Moves[j].src) && (Strike[dst] <= tend))
        {
          LineBlocked[lno] = 1;
        }
        
        LineBlocked2[lno] = LineBlocked[lno];
        if ((!LineBlocked[lno]) && ((Moves[j].src >= 0) || (tend < Strike[dst])))
        {
          next = Moves[j].next;
          Tracks2[next] = Tracks[next];
          Tracks2[dst] = Tracks[dst];
          if (-1 != next)
          {
            CityLines[next][ccnt[next]] = lno;
            if (0 == ccnt[next])
              S_CL[s_cl_cnt++] = next;
            ++ccnt[next];
          }
          InCity[lno] = dst;
        }
        ++j;
      }

      for (k = i; k < j; k++)
      {
        if ((Moves[k].src >= 0) && (Strike[Moves[k].dst] <= tend))
        {
          BlockLine(Moves[k].lno);
        }
        if ((Moves[k].next >= 0) && (0 == Tracks2[Moves[k].next]))
        {
          BlockLine(Moves[k].lno);
        }
      }
      
      for (k = i; k < j; k++)
      {
        int ok = 1;
        
        lno = Moves[k].lno;
        if (LineBlocked2[lno])
          continue;
        src = Moves[k].src;
        dst = Moves[k].dst;

        if (Tracks2[dst] <= 0)
        {
          LineBlocked[lno] = 1;
          ok = 0;
        }
        
        if (LineBlocked[lno])
        {
          --Tracks2[dst];
        }
        if (ok && (src >= 0))
        {
          G[src][gcnt[src]].tbeg = Moves[k].tbeg;
          G[src][gcnt[src]].tend = tend;
          G[src][gcnt[src]].dst = dst;
          gcnt[src]++;
          assert(gcnt[src] <= M);
        }

      }

      while (s_cl_cnt--)
        ccnt[S_CL[s_cl_cnt]] = 0;
      assert(-1 == s_cl_cnt);
      s_cl_cnt = 0;

      i = j-1;
    }
#ifndef NDEBUG
    for (i = 0; i < N; i++)
      assert(Tracks[i] >= 0);
#endif

    for (i = 0; i < N; i++)
    {
      CityTime[i] = MAXT+1;
      Used[i] = 0;
    }
    CityTime[SRC] = 0;
    for (i = 0; i < N; i++)
    {
      int min = -1;
      for (j = 0; j < N; j++)
        if ((!Used[j]) && ((-1 == min) || (CityTime[j] < CityTime[min])))
          min = j;
      assert((min >= 0) && (!Used[min]));
      Used[min] = 1;
      for (j = 0; j < gcnt[min]; j++)
      {
        int tbeg = G[min][j].tbeg, tend = G[min][j].tend;
        int dst = G[min][j].dst;
        if ((tbeg >= CityTime[min]) && (tend < CityTime[dst]))
          CityTime[dst] = tend;
      }
    }

    if (CityTime[DST] <= MAXT)
      printf("%d\n", CityTime[DST]);
    else
      printf("NIE\n");
  }
  
  return 0;
}

