/*
 * VIII Wiosenny Turniej w Programowaniu Zespolowym
 * Politechnika Poznanska, 29.05.2004
 *
 * Program sprawdzajacy do zadania A - Kryminal
 * Zlozonosc: O(N+M)
 *
 * Autor programu: Bartosz Nowierski
 */

#include <stdio.h>
/*#define NDEBUG*/
#include <assert.h>

#define MAXN 10000
#define INF 2100000000


int main(int argc, char *argv[])
{
  FILE *fin, *fout, *fsol;
  int D;
  char str[100000];
  int optsol, sol;
  int N, M, i;
  int P[MAXN];
  int f;
  int intelig;
  

  assert(4 == argc);
  fin = fopen(argv[1], "r");
  assert(NULL != fin);
  fout = fopen(argv[2], "r");
  assert(NULL != fout);
  fsol = fopen(argv[3], "r");
  assert(NULL != fsol);

  if (fscanf(fin, "%d", &D) < 1)
    assert(0);
  while (D--)
  {
    if (fgets(str, 100000, fout) == NULL)
      assert(0);
    if (sscanf(str, "%d", &optsol) < 1)
      assert(0);
    if (fscanf(fsol, "%d", &sol) < 1)
    {
      printf("Blad wczytywania inteligencji\n");
      goto WA;
    }
    if (sol != optsol)
    {
      printf("Inteligencja rozna od oczekiwanej\n");
      goto WA;
    }
      
    if (fscanf(fin, "%d%d", &N, &M) < 2)
      assert(0);
    assert(N <= MAXN);
    for (i = 0; i < N; i++)
      P[i] = -1;
    for (i = 0; i < N; i++)
    {
      if (fscanf(fsol, "%d", &f) < 1)
      {
        printf("Blad wczytywania faktow (%d)\n", i+1);
        goto WA;
      }
      if ((f < 1) || (f > N))
      {
        printf("Numer faktu spoza zasiegu (%d: %d)\n", i+1, f);
        goto WA;
      }
      f--;
      if (P[f] >= 0)
      {
        printf("Fakt powtarza sie (%d: %d)\n", i+1, f+1);
        goto WA;
      }
      P[f] = i;
    }
    
    intelig = INF;
    for (i = 0; i < M; i++)
    {
      int A, B;
      int x, y;
      
      if (fscanf(fin, "%d%d%d%d", &A, &B, &x, &y) < 4)
        assert(0);
      A--;
      B--;
      assert((x < INF) && (y < INF));
      if (P[A] > P[B])
        x = y;
      if (x < intelig)
        intelig = x;
    }
    assert(intelig < INF);
    
    assert(intelig <= optsol);
    if (intelig != optsol)
    {
      printf("Uklad faktow nie wymaga podanej inteligencji (%d)\n", intelig);
      goto WA;
    }
  }
  
  fclose(fin);
  fclose(fout);
  fclose(fsol);
  printf("ACCEPTED\n");
  return 0;

WA:
  fclose(fin);
  fclose(fout);
  fclose(fsol);
  printf("WRONG ANSWER\n");
  return 3;
}
