/* IX Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Wiec
   Autor: Wojciech Jaskowski
 */

#include <stdio.h>
#include <assert.h>
#include <values.h>

#define MAX_N 100
#define MAX_VAL 100 

//#define DEBUG

int n,k;
unsigned p[MAX_N][MAX_N];
unsigned d[MAX_N][MAX_N];
int perm[MAX_N];
int eval;
int delta[MAX_N][MAX_N];

inline void swap(int* a, int* b) {
    int c = *a;
    *a = *b;
    *b = c;
}

int evaluate() {
    int i,j;
    int eval = 0;

    for (i=0; i<n; ++i)
        for (j=0; j<n; ++j)
            eval += p[i][j] * d[perm[i]][perm[j]];
    return eval;
}

void readin(void) {
    int i,j;

    scanf("%d%d", &n, &k);
    assert(n >= 2 && n <= MAX_N);
    assert(k >= 1 && k <= MAX_N);
    for (i=0; i<n; ++i)
        for (j=0; j<n; ++j) {
            scanf("%u", &p[i][j]);
            assert(p[i][j] >= 0);
            assert(p[i][j] <= MAX_VAL);
            if (i==j) assert(p[i][j] == 0);
        }

    for (i=0; i<n; ++i)
        for (j=0; j<n; ++j) {
            scanf("%u", &d[i][j]);
            assert(d[i][j] >= 0);
            assert(d[i][j] <= MAX_VAL);
            if (i==j) assert(d[i][j] == 0);
            if (i>j) assert(d[i][j] == d[j][i]);
        }

    int x[MAX_N];
    for (i=0; i<n; ++i)
        x[i] = 0;

    for (i=0; i<n; ++i) {
        scanf("%d", &perm[i]);
        perm[i]--;
        assert(perm[i]>=0);
        assert(perm[i]<n);
        assert(x[perm[i]] == 0);
        x[perm[i]] = 1;
    }
    eval = evaluate();
}

int delta_slow(int i, int j) {
    int de = (p[i][j] - p[j][i]) * (d[perm[j]][perm[i]] - d[perm[i]][perm[j]]) +
            (p[i][i] - p[j][j]) * (d[perm[j]][perm[j]] - d[perm[i]][perm[i]]);
    int k;
    for (k=0; k<n; ++k) if (k!=i && k!=j)
        de += (p[i][k] - p[j][k]) * (d[perm[j]][perm[k]] - d[perm[i]][perm[k]]) + 
             (p[k][i] - p[k][j]) * (d[perm[k]][perm[j]] - d[perm[k]][perm[i]]);
    return de;
}

/* Computes new value of solution for permutation p, 
   when i and j are swapped and last swapped indexes were r and s - O(1) */
int delta_fast(int r, int s, int i, int j) {
    return delta[i][j] +
        (p[r][i] - p[r][j] + p[s][j] - p[s][i]) * 
            (d[perm[s]][perm[i]] - d[perm[s]][perm[j]] + d[perm[r]][perm[j]] - d[perm[r]][perm[i]]) +
        (p[i][r] - p[j][r] + p[j][s] - p[i][s]) * 
            (d[perm[i]][perm[s]] - d[perm[j]][perm[s]] + d[perm[j]][perm[r]] - d[perm[i]][perm[r]]);
}

/* Updates delta array, which stores costs of swaping 2 indexes.
   u, v are last swapped indexes */
void delta_update(int v, int u) {
    int i,j;
    for (i=0; i<n; ++i)
        for (j=i+1; j<n; ++j)
            if (i!=v && i!=u && j!=v && j!=u)
                delta[i][j] = delta_fast(u, v, i, j);
            else
                delta[i][j] = delta_slow(i, j);
    
}

int inline sec(int i, int j) {
    return (i+1)*(n+1) + j+1;
}

int best_neighbour() {
    int i, j;
    int u = 0, v = 0;
    int best = INT_MAX;

    for (i=0; i<n; ++i)
        for (j=i+1; j<n; ++j) {
            if (delta[i][j] < best || 
                    (delta[i][j] == best && sec(i, j) < sec(u, v))) {
                u = i; v = j;
                best = delta[i][j];
            }
        }
    if (best < 0) {
        swap(&perm[u], &perm[v]);
        eval += best;
        delta_update(u, v);
    }
    return (best < 0); 
}

/* Initializes delta array */
void delta_init() {
    int i,j;
    for (i=0; i<n; ++i)
        for (j=i+1; j<n; ++j)
            delta[i][j] = delta_slow(i, j);
}

int main(void) {
    int d;
    scanf("%d", &d);
    while (d--) {
        int i;
        readin();
        delta_init();
        int last=k;
#ifdef DEBUG
        printf("eval = %d\n", eval);
#endif
        for (i=0; i<k; ++i) {
            if (!best_neighbour()) {
                last=i;
                break;
            }
#ifdef DEBUG
            printf("eval = %d\n", eval);
#endif
        }
#ifdef DEBUG
        printf("lastk = %d\n", last);
#endif
        printf("%d\n", eval);
    }

    return 0;
}
