/* IX Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Korespondencja
   Autor: Wojciech Jaskowski
 */

#include <stdio.h>
#include <assert.h>
#include <values.h>
#include <stdlib.h>
#include <string.h>

#define MAX_N 1000000
#define MAX_SUM 1000000
#define E -1

inline int max(int a, int b) {
    return (a>b ? a : b);
}

int A[8] = {0,E,1,2,0,E,1,2};
int B[10] = {0,E,E,1,0,2,E,1,E,2};
int C[10] = {0,E,1,E,0,2,1,E,E,2};
int D[8] = {0,1,E,2,0,1,E,2};
int V[7] = {0,1,2,E,0,1,2};

int ArrSize[4] = {8, 10, 10, 8};
int* Arr[4] = {A, B, C, D};
int ArrJoin[4] = {3, 4, 3, 2};

int n;
int l[MAX_N];
int res[MAX_SUM*3];
int best[MAX_SUM*3];

void readin() {
    int i;

    scanf("%d", &n);
    for (i=0; i<n; ++i)
        scanf("%d", &l[i]);
}

void rescopy(int* res, int Arr[], int size, int p[4]) {
    int i;
    for (i=0; i<size; ++i)
        if (Arr[i] != E) {
            res[i] = p[Arr[i]];
        }
}

int try_v(int* res, int slotno, int p[][4], int slotcnt) {
    int len = 0;
    while (slotcnt - slotno > 0) {
        rescopy(res, V, sizeof(V)/sizeof(V[0]), p[slotno]);
        slotno++;
        res += 7;
        len += 7;
    }
    return len;
}

int try_abcd(int* res, int slotno, int p[][4], int slotcnt, int idx) {
    int* arr = Arr[idx];
    int size = ArrSize[idx];
    int join = ArrJoin[idx];

    int len = 0;
    while (slotcnt - slotno > 0) {
        rescopy(res, arr, size, p[slotno++]);

        res += size - join;
        if (slotcnt - slotno > 0) 
            len += size - join;
        else
            len += size;

        idx = (idx+1)%4;
        arr = Arr[idx];
        size = ArrSize[idx];
        join = ArrJoin[idx];
    }
    return len;
}

void clearres(int start, int end) {
    int i;
    for (i=start; i<end; ++i)
        res[i] = E;
}

void solve() {
    int maxl = 0;
    int suml = 0;
    int i,j;

    for (i=0; i<n; ++i) {
        if (maxl < l[i])
            maxl = l[i];
        suml += l[i];
    }
    int d = max(maxl, (suml-1)/4 + 1);

    int p[d][4];

    int last = 0;

    clearres(0, 3*suml);

    int border = d;
    for (i=0; i<4; ++i)
        for (j=0; j<d; ++j) {
            if (l[last] == 0) {
                last++;
                if (last >= n) {
                    border = j;
                    goto end;
                }
            }
            l[last]--;
            p[j][i] = last;
        }
end: 

    for (i=0; i<border; ++i) {
        for (j=0; j<4; ++j) {
            res[8*i+j] = res[8*i+4+j] = p[i][j];
        }
    }
    int len = INT_MAX;
    int besttype = 0;

    len = try_v(res + 8*border, border, p, d);
    memcpy(best, res, sizeof(int)*(8*border + len));
    clearres(8*border, 8*border + len);
    besttype = 0;

    for (i=0; i<4; ++i) {
        int r = try_abcd(res + 8*border, border, p, d, i);
        if (r < len) {
            len = r;
            memcpy(best, res, sizeof(int)*(8*border + len));
            besttype = i+1;
        }
        clearres(8*border, 8*border + len);
    }

    printf("%d ", 8*border + len);
    for (i=0; i<8*border+len; ++i) {
        printf("%d ", best[i]+1);
    }
    //fprintf(stderr, "best type = %d\n", besttype);
    printf("\n");
}

int main() {
    int d;
    scanf("%d", &d);
    while (d--) {
        readin();
        solve();
    }
    return 0;
}
