/* IX Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Enigpat
   Autor: Bartosz Wieloch
 */

#include <cstdio>

typedef unsigned int uint;

#define MAXSIZE (500000+1)

int a[MAXSIZE];
int b[MAXSIZE];
int c[MAXSIZE];

int val[MAXSIZE];
int rank[MAXSIZE];
int ptr[MAXSIZE];

int N;
long long _p;
uint k;
uint l;
uint m;

inline uint nextp()
{
    return _p = (k*_p+l) % m;
}

void setab()
{
    a[1] = 1;
    b[1] = a[1] + ((uint)_p % (N-a[1]+1));
    for (int i=2;i<=N;i++)
    {
	a[i] = a[i-1] + nextp() % (i - a[i-1] + 1);
	b[i] = a[i] + nextp() % (N - a[i] + 1);
    }
    
}

uint solve()
{
    setab();

#ifdef DEBUG    
    printf("a=");
    for (int i=1; i <= N; i++)
        printf(" %u", a[i]);
    printf("\n");
    printf("b=");
    for (int i=1; i <= N; i++)
        printf(" %u", b[i]);
    printf("\n");
#endif

    // make sets
    for (int i=0; i <= N; i++)
    {
	val[i] = ptr[i] = i;
	rank[i] = 0;
    }

    for (int i=N; i >= 1; i--)
    {
	// findset(b[i])
	int set1 = b[i];
	while (ptr[set1] != set1)
	    set1 = ptr[set1];
	    
	if (val[set1] < a[i])
	    return 666;
	else
	    c[i] = val[set1];
	    
	// findset(val[set1]-1)
	int set2 = val[set1]-1;
	int set2start = set2;
	while (ptr[set2] != set2)
	    set2 = ptr[set2];
	    
	// link(set1, set2)
	int set;
	if (rank[set1] > rank[set2])
	{
	    set = set1;
	    val[set] = val[set2];
	}
	else
	{
	    set = set2;
	    if (rank[set1] == rank[set2])
		++rank[set2];
	}
	
	// updatepaths
	int tmp;
	
	// path1
	set1 = b[i];
	while (ptr[set1] != set1)
	{
	    tmp = ptr[set1];
	    ptr[set1] = set;
	    set1 = tmp;
	}
	ptr[set1] = set;
	
	// path2;
	set2 = set2start;
	while (ptr[set2] != set2)
	{
	    tmp = ptr[set2];
	    ptr[set2] = set;
	    set2 = tmp;
	}
	ptr[set2] = set;
    }
    
    uint d = c[1];
    for (int i=2;i<=N;i++)
	d = d*48271 + c[i];
    
    return d;
}

int main()
{
    int M;
    scanf("%d", &M);
    while (M--)
    {
	uint p1;
	scanf("%d%u%u%u%u", &N, &p1, &k, &l, &m);
	_p = p1;
	uint result = solve();
	printf("%u\n", result);
	
#ifdef DEBUG
	printf("c=");
	for (int i=1; i <= N; i++)
	    printf(" %u", c[i]);
	printf("\n");
	printf("%s\n", check()?"OK":"bleee");
#endif
    }
}
