/* Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Gra w liczby
   Author: Bartosz Wieloch
 */

#include <cstdio>
#include <vector>
#include <algorithm>

using namespace std;

typedef vector<int> vint;

struct Node
{
    vint buff;
    
    int lvalue;
    int rvalue;
    int value;
    
    Node* left;
    Node* right;
    
    int leftsize;
    int rightsize;
    
    Node(int lval, int rval) : buff(), lvalue(lval), rvalue(rval), value((lval+rval)/2), left(NULL), right(NULL), leftsize(0), rightsize(0)
    {
    }
    
    void Add(int v)
    {
	buff.push_back(v);
    }
    
    void Split()
    {
	if (left == NULL)
	    left = new Node(lvalue, value);
	if (right == NULL)
	    right = new Node(value+1, rvalue);
    
	for (vint::iterator iter = buff.begin(); iter != buff.end(); iter++)
	    if (*iter <= value)
	    {
		left->Add(*iter);
		leftsize++;
	    }
	    else
	    {
		right->Add(*iter);
		rightsize++;
	    }
	buff.clear();
    }

    int Find(int nr)
    {
	if (lvalue==rvalue)
	    return value;
	    
	Split();
	
	if (nr < leftsize)
	    return left->Find(nr);
	else
	    return right->Find(nr-leftsize);
    }
    
    ~Node()
    {
	if (left)
	    delete left;
	if (right)
	    delete right;
    }
};


int main()
{
    int lzest;
    scanf("%d", &lzest);
    
    while(lzest--)
    {
	int n,k;
	scanf("%d%d",&n,&k);
	
	Node tree(1,1000000);
	tree.Add(k);
	
	for (int i=1;i<n;i++)
	{
	    scanf("%d", &k);
	    if (k > 0)
	        tree.Add(k);
	    else
		printf("%d ", tree.Find(-k-1));
	}
        printf("\n");
    }
    return 0;
}
