/* Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Studnia
   Author: Wojciech Jaskowski
   Uwagi: To rozwiazanie jest bardzo szybkie, poniewaz graf przejsc zostal wygenerowany statycznie i wpisany w zrodlo tego pliku. Na zawodach programy mialy dzilac niewolniej niz 15 razy wolniej od tego programu
 */

#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>

#define MAX_NEIGHBOURS 30
#define MAP_W 3
#define MAP_H 3
#define NO_FIELDS (MAP_W * MAP_H)
#define NO_SURF_CODES (1<<NO_FIELDS)
#define NO_MIN_CODES 102
#define MAX_N 10000
#define MAX_MODULO 254

struct edge {
    int node;
    int w;
};
typedef struct edge edge;
typedef int surf[MAP_W][MAP_H];

struct edge nodes[NO_MIN_CODES][MAX_NEIGHBOURS];
int minsurf[NO_MIN_CODES];

int testno = 0;

void surfprint(surf s) {
    int i,j;
    for (i=0; i<MAP_W; ++i) {
        for (j=0; j<MAP_H; ++j) {
            printf("%d", s[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}

int surfcode(surf s) {
    int i,j;
    int base = NO_SURF_CODES/2;
    int code = 0;
    for (i=0; i<MAP_W; ++i)
        for (j=0; j<MAP_H; ++j) {
            code += base*s[i][j];
            base /= 2;
        }
    assert(0 <= code);
    assert(code < NO_SURF_CODES);
    return code;
}

int rot[MAP_W][MAP_H][2] = {
    {{0,2}, {1,2}, {2,2}},
    {{0,1}, {1,1}, {2,1}},
    {{0,0}, {1,0}, {2,0}}
};

int mir[MAP_W][MAP_H][2] = {
    {{0,2}, {0,1}, {0,0}},
    {{1,2}, {1,1}, {1,0}},
    {{2,2}, {2,1}, {2,0}}
};

void rotate(surf s) {
    surf tmp;
    int i,j;
    for (i=0; i<MAP_W; ++i)
        for (j=0; j<MAP_H; ++j) tmp[i][j] = s[rot[i][j][0]][rot[i][j][1]];
    memcpy(s, tmp, sizeof(surf));
}

void mirror(surf s) {
    surf tmp;
    int i,j;
    for (i=0; i<MAP_W; ++i) {
        for (j=0; j<MAP_H; ++j) {
            tmp[i][j] = s[mir[i][j][0]][mir[i][j][1]];
        }
    }
    memcpy(s, tmp, sizeof(surf));
}

int surfnormalize(surf s) {
    surf best;
    memcpy(best, s, sizeof(surf));
    int bestcode = surfcode(best);
    int code;

    int i;
    for (i=0; i<4; ++i) {
        rotate(s);
        code = surfcode(s);
        if (code < bestcode) {
            bestcode = code;
            memcpy(best, s, sizeof(surf));
        }
    }
    mirror(s);
    for (i=0; i<4; ++i) {
        rotate(s);
        code = surfcode(s);
        if (code < bestcode) {
       bestcode = code;
            memcpy(best, s, sizeof(surf));
        }
    }
    return bestcode;
}

int n,modulo;
surf map;

unsigned char cache[MAX_N+1][NO_MIN_CODES];

int go(int n, int code) {
    int i = 0;
    int res = 0;

    if (cache[n][code] < 0xFF)
        return cache[n][code];

    if (n == 0) {
        return (code == 0);
    }
    
    while (nodes[code][i].w > 0) {
        res += (nodes[code][i].w * go(n-1, nodes[code][i].node)) % modulo;
        res %= modulo;

        i++;
    }
    return cache[n][code]=res;
}

int decodecode(int code) {
    int i;
    for (i=0; i<NO_MIN_CODES; ++i)
        if (code == minsurf[i])
            return i;
    assert(0);
}

int solve(int n, surf map) {

    int startcode = decodecode(surfnormalize(map));

    return go(n, startcode);
}

void readin() {
    int i,j;
    scanf("%d%d", &n, &modulo);
    for (i=0; i<MAP_W; ++i)
        for (j=0; j<MAP_H; ++j) {
            scanf("%d", &map[i][j]);
        }
}

int main() {
    int d;
    scanf("%d", &d);
    while (d--) {
        testno++;
        readin();
        memset(cache, 0xFF, (n+1)*sizeof(cache[0]));
        printf("%d\n", solve(n, map));
    }
    return 0;
}

int minsurf[NO_MIN_CODES] =
{
0,1,2,3,5,7,10,11,12,13,14,15,16,17,18,19,21,23,26,27,28,29,30,31,40,41,42,43,45,47,56,57,58,59,61,63,68,69,70,71,78,79,84,85,86,87,94,95,97,98,99,101,102,103,105,106,107,108,109,110,111,113,114,115,117,118,119,121,122,123,124,125,126,127,170,171,173,175,186,187,189,191,229,231,238,239,245,247,254,255,325,327,335,341,343,351,365,367,381,383,495,511};
struct edge nodes[NO_MIN_CODES][MAX_NEIGHBOURS] =
{
{{1,16},{5,12},{9,8},{12,2},{15,8},{20,8},{23,8},{38,16},{41,8},{48,4},{53,8},{58,8},{65,4},{67,4},{70,4},{73,8},{97,4},{101,1} },
{{0,4},{3,12},{8,8},{11,6},{14,4},{19,3},{22,2},{28,2},{31,4},{35,2},{40,2},{50,2},{52,2},{54,2},{57,2},{60,2},{62,1},{69,2},{72,2},{83,2},{89,1} },
{{4,6},{13,4},{17,3},{21,2},{36,4},{39,8},{44,4},{47,2},{51,4},{61,1},{66,2},{71,2},{92,2},{96,1},{99,1} },
{{1,6},{5,3},{9,2},{12,1},{15,3},{20,3},{23,2},{38,4},{41,1},{48,1},{53,1},{58,1},{65,1},{67,1},{70,1},{73,1} },
{{2,6},{7,2},{10,4},{18,2},{25,4},{29,1},{30,1},{33,2},{49,2},{56,2},{68,2},{76,1},{81,1} },
{{0,3},{3,6},{8,2},{11,2},{14,3},{19,2},{28,1},{31,2},{35,1} },
{{16,2},{37,4},{42,1},{45,2},{64,2},{91,2},{95,1} },
{{4,2},{13,3},{17,2},{36,2},{39,2},{44,2},{47,1} },
{{1,4},{5,1},{9,4},{12,1},{15,3},{20,1},{23,1},{34,1},{38,2},{46,1},{48,1},{53,1},{58,1},{63,1},{82,1},{87,1} },
{{0,1},{3,2},{8,4},{11,1},{14,1},{22,1},{31,1},{50,1},{54,1},{62,1},{69,1} },
{{4,2},{13,1},{21,1},{36,1},{39,1},{44,1},{51,1},{61,1},{66,1} },
{{1,3},{5,1},{9,1},{12,1},{15,2},{20,1},{23,1} },
{{0,2},{3,8},{8,8},{11,8},{52,4},{54,4},{57,4},{60,8},{100,1} },
{{2,4},{7,3},{10,2},{25,4},{29,2},{49,1},{56,2},{59,2},{85,1} },
{{1,4},{5,3},{9,2},{38,4},{41,2},{48,1},{53,2},{58,2},{97,1} },
{{0,1},{3,3},{8,3},{11,2},{52,1},{54,1},{57,1},{60,1} },
{{6,2},{24,1},{27,2},{55,2},{77,1} },
{{2,3},{7,2},{25,2},{29,1} },
{{4,2},{36,1},{39,2},{51,2},{92,1} },
{{1,3},{5,2},{38,2},{41,1} },
{{0,1},{3,3},{8,1},{11,1},{28,1},{40,1},{50,1},{83,1} },
{{2,1},{10,1},{25,1},{49,1},{56,1} },
{{1,1},{9,1},{38,1},{48,1},{53,1} },
{{0,1},{3,2},{8,1},{11,1} },
{{16,2},{37,4},{42,2},{45,4},{91,2},{98,1} },
{{4,2},{13,2},{17,1},{21,1},{36,1},{39,1},{44,1},{51,1},{71,1} },
{{43,2},{90,1},{94,1} },
{{16,1},{37,1},{42,1},{45,1} },
{{1,2},{5,1},{20,2},{48,1},{67,1} },
{{4,1},{13,2},{17,1} },
{{4,2},{36,2},{39,4},{96,1} },
{{1,2},{5,1},{9,1},{38,1},{58,1} },
{{37,2},{91,1} },
{{4,1},{36,1},{39,1} },
{{8,2},{54,1} },
{{1,2},{5,1} },
{{2,8},{7,4},{10,4},{18,2},{25,4},{30,2},{33,4},{59,4},{88,1} },
{{6,4},{24,2},{27,2},{32,2},{55,2},{79,1} },
{{0,2},{3,4},{8,2},{14,2},{19,1},{22,1},{31,1},{40,1},{52,1},{57,1},{72,1} },
{{2,4},{7,1},{10,1},{18,1},{25,1},{30,1},{33,1} },
{{1,2},{20,2},{38,2},{65,1} },
{{0,2},{3,2},{14,2},{19,1} },
{{6,2},{24,2},{27,4},{84,1} },
{{26,2},{75,1} },
{{2,2},{7,1},{10,1},{25,1},{59,1} },
{{6,1},{24,1},{27,1} },
{{8,2},{52,1} },
{{2,2},{7,1} },
{{0,1},{3,2},{8,2},{14,1},{22,2},{28,1},{50,2},{80,1} },
{{4,2},{13,1},{21,2},{51,2},{86,1} },
{{1,1},{9,1},{20,1},{48,1},{63,1} },
{{2,2},{10,1},{18,1},{25,1},{49,1},{68,1} },
{{1,2},{12,1},{15,2},{38,2},{46,1} },
{{0,1},{3,1},{8,1},{14,1},{22,1} },
{{1,2},{9,2},{12,1},{15,2},{34,1} },
{{16,1},{37,1},{64,1} },
{{4,1},{13,1},{21,1} },
{{1,2},{12,1},{15,2},{38,2},{70,1} },
{{0,1},{3,1},{8,1},{14,1},{31,1} },
{{13,1},{36,1},{44,1} },
{{1,1},{12,1},{15,1} },
{{2,1},{10,2},{76,1} },
{{1,1},{9,2},{82,1} },
{{8,1},{50,1} },
{{6,1},{55,1} },
{{0,1},{3,2},{40,1} },
{{2,1},{10,1} },
{{0,1},{3,2},{28,1} },
{{4,1},{51,1} },
{{1,1},{9,1} },
{{0,1},{3,2},{57,1} },
{{2,1},{25,1} },
{{1,1},{38,1} },
{{0,1},{3,1} },
{{93,1} },
{{43,1} },
{{4,1},{61,1} },
{{16,1} },
{{90,1} },
{{37,1} },
{{48,1} },
{{4,1} },
{{8,2},{62,1} },
{{1,1},{20,1} },
{{42,1} },
{{13,1} },
{{49,1} },
{{8,1} },
{{36,1} },
{{1,1} },
{{26,4},{78,1} },
{{6,2},{24,1},{32,1} },
{{2,2},{18,1} },
{{74,1} },
{{26,1} },
{{6,1} },
{{2,2},{30,1} },
{{0,1},{14,1} },
{{24,1} },
{{2,1} },
{{12,1} },
{{0,1} }};
