/* Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Go
   Author: Grzegorz Sobanski
 */

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cassert>

int n;
char p[1000][1000];
char k[1000][1000];

void seki2(int y, int x, int kol)
{
	if (k[y][x] == 3)
		return;
	if (p[y][x] == 0)
		kol = 0;
	if (kol != 0 && p[y][x] != 0 && p[y][x] != kol)
		return;
	if (p[y][x] != 0)
		kol = p[y][x];

	k[y][x] = 3;
	if (y > 0)
		seki2(y - 1, x, kol);
	if (y < n - 1)
		seki2(y + 1, x, kol);
	if (x > 0)
		seki2(y, x - 1, kol);
	if (x < n - 1)
		seki2(y, x + 1, kol);
}



int koloruj(int y, int x, int kol)
{
	int sasiedzi = 0;

	if (y > 0) {
		if (p[y - 1][x] == 1)
			sasiedzi = 1;
		if (p[y - 1][x] == 2)
			sasiedzi = 2;
	}

	if (y < n - 1) {
		if (p[y + 1][x] == 1 && sasiedzi == 0)
			sasiedzi = 1;
		if (p[y + 1][x] == 2 && sasiedzi == 0)
			sasiedzi = 2;

		if (p[y + 1][x] == 1 && sasiedzi == 2)
			sasiedzi = 3;
		if (p[y + 1][x] == 2 && sasiedzi == 1)
			sasiedzi = 3;
	}

	if (sasiedzi != 3 && x > 0) {
		if (p[y][x - 1] == 1 && sasiedzi == 0)
			sasiedzi = 1;
		if (p[y][x - 1] == 2 && sasiedzi == 0)
			sasiedzi = 2;

		if (p[y][x - 1] == 1 && sasiedzi == 2)
			sasiedzi = 3;
		if (p[y][x - 1] == 2 && sasiedzi == 1)
			sasiedzi = 3;
	}

	if (sasiedzi != 3 && x < n - 1) {
		if (p[y][x + 1] == 1 && sasiedzi == 0)
			sasiedzi = 1;
		if (p[y][x + 1] == 2 && sasiedzi == 0)
			sasiedzi = 2;

		if (p[y][x + 1] == 1 && sasiedzi == 2)
			sasiedzi = 3;
		if (p[y][x + 1] == 2 && sasiedzi == 1)
			sasiedzi = 3;
	}

//	printf("%d:%d - %d, %d\n", y, x, sasiedzi, kol);

	if (sasiedzi == 3 || (sasiedzi != 0 && kol != 0 && sasiedzi != kol)) {
		seki2(y, x, 0);
		return 3;
	}

	if (sasiedzi == 0 && kol != 0)
		sasiedzi = kol;

	if (sasiedzi == 0)
		return 0;

	k[y][x] = sasiedzi;
	
	if (y > 0 && p[y - 1][x] == 0 && k[y - 1][x] == 0)
		if (koloruj(y - 1, x, sasiedzi) == 3)
			return 3;
	if (y < n - 1 && p[y + 1][x] == 0 && k[y + 1][x] == 0)
		if (koloruj(y + 1, x, sasiedzi) == 3)
			return 3;
	if (x > 0 && p[y][x - 1] == 0 && k[y][x - 1] == 0)
		if (koloruj(y, x - 1, sasiedzi) == 3)
			return 3;
	if (x < n - 1 && p[y][x + 1] == 0 && k[y][x + 1] == 0)
		if (koloruj(y, x + 1, sasiedzi) == 3)
			return 3;
	return sasiedzi;
}



int main()
{
	int d;
	scanf("%d", &d);
	while (d--) {
		memset(k, 0, 1000*1000);

		int jb, jc;
		scanf("%d%d%d", &n, &jc, &jb);
		assert(n >= 5);
		assert(n <= 1000);
		assert(jb >= 0);
		assert(jb <= 10000);
		assert(jc >= 0);
		assert(jc <= 10000);

		for (int y = 0; y < n; y++) {
			char buf[1010];
			scanf("%s", buf);
			assert(strlen(buf) == n);
			for (int x = 0; x < n; x++) {
				if (buf[x] == '*')
					p[y][x] = 0;
				if (buf[x] == 'B')
					p[y][x] = 1;
				if (buf[x] == 'C')
					p[y][x] = 2;
			}
		}

		/*
		for (int y = 0; y < n; y++) {
			for (int x = 0; x < n; x++)
				printf("%d", p[y][x]);
			printf("\n");
		}
		printf("\n");
		*/

		for (int y = 0; y < n; y++)
			for (int x = 0; x < n; x++)
				if (k[y][x] == 0 && p[y][x] == 0) {
//					printf("***\n");
					koloruj(y, x, 0);
				}

		/*
		printf("\n");
		for (int y = 0; y < n; y++) {
			for (int x = 0; x < n; x++)
				printf("%d", k[y][x]);
			printf("\n");
		}
		*/

		int biale = 0;
		int czarne = 0;

		for (int y = 0; y < n; y++)
			for (int x = 0; x < n; x++)
				if (k[y][x] == 1)
					biale++;
				else if (k[y][x] == 2)
					czarne++;

		biale += jb + 6;
		czarne += jc;

		if (biale >= czarne)
			printf("%d.5\n", biale - czarne);
		else
			printf("-%d.5\n", czarne - biale - 1);
	}
	return 0;
}
