/* Wiosenny Turniej w Programowaniu Zespolowym, Politechnika Poznanska 2005
   Zadanie: Kontrola biletow
   Author: Piort Zielinski
   Time complexity: O(n k logn)
   Memory complexity: O(n)
 */

#define NDEBUG			// disable assertions
#include <iostream>
#include <stdlib.h>
#include <assert.h>

using namespace std;

const int maxn = 5000;		// the maximum number of cities
const int maxsize = 5;		// the maximum size of a single city
const int INF = 0x70000000;	// the value of infinity

int n;				// the number of cities
int k;				// the number of controls
int sizes[maxn];		// sizes of cities
int sums[maxn+1];	        // sums[i] = sizes[0] + ... + sizes[i-1]
int prevmin[maxn+1];		// data from the previous iteration
int thismin[maxn+1];		// date from this iteration

// compute a single entry in the thismin table
int computethisitem(int prevfrom, int prevto, int i) {
  int bestprev = -1;
  thismin[i] = INF;
  for(int j=prevfrom; j<=i && j<=prevto; j++) {
    int min = prevmin[j] + (sums[i] - sums[j])*(sums[i] - sums[j]);
    if (min < thismin[i]) {
      thismin[i] = min;
      bestprev = j;
    }
  }
  assert(bestprev >= 0);

  return bestprev;
}

// compute all entries in the thismin table using the
// divide-and-conquer approach
void computethistable(int prevfrom, int prevto, int thisfrom, int thisto) {
  if (thisto < thisfrom)
    return;

  assert(prevfrom <= prevto);

  int thiscenter = (thisfrom + thisto) / 2;
  int prevcenter = computethisitem(prevfrom, prevto, thiscenter);

  computethistable(prevfrom, prevcenter, thisfrom, thiscenter - 1);
  computethistable(prevcenter, prevto, thiscenter+1, thisto);
}
    
// compute the answer
int compute(void) {
  sums[0] = 0;
  for(int i=0; i<n; i++)
    sums[i+1] = sums[i] + sizes[i];
  for(int i=0; i<=n; i++)
    prevmin[i] = sums[i] * sums[i];  

  for(int controls=0; controls<k; controls++) {
    computethistable(0,n,0,n);
#ifndef NDEBUG			// check the result with the slower alg
    for(int i=0; i<=n; i++) {
      int value = thismin[i];
      computethisitem(0,n,i);
      assert(thismin[i] == value); 
    }
#endif
    for(int i=0; i<=n; i++)
      prevmin[i] = thismin[i]; // replace with memcpy for speed
  }

  return (sums[n] * sums[n] - prevmin[n]) / 2; // matemagical formula
}

int main(void) {
  for(;;) {
    cin >> n >> k;
    
    if (k == 0 && n == 0)	// 0 0 marks the end of the input
      break;
    
    assert(maxn * maxsize < 0x8000);
    assert(n == 0 || n >= 2);
    assert(n <= maxn);
    assert(0 <= k && k < n);		

    for(int i=0; i<n; i++) {
      cin >> sizes[i];
      assert(0 < sizes[i] && sizes[i] <= maxsize);
    }
    
    cout << compute() << "\n";
  }
  return 0;
}
