/* IX Wiosenny Turniej w Programowaniu Zespolowym
   Program sprawdzajacy do zadania Korespondencja
   Autor: Wojciech Jaskowski
   Sposob uzycia: check test-wzorcowy.in test-wzorcowy.out testowany.out
   Zwraca: 0, jesli odpowiedz prawidlowa, 1 jesli nieprawidlowa
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define MAX_N 1000000
#define MAX_L 1000000

int n;
int l[MAX_N+1];
int lcnt[MAX_N+1];
int lastpos[MAX_N+1];

void clear() {
    int i;
    for (i=1; i<=n; ++i) {
        lcnt[i] = 2*l[i];
        lastpos[i] = -1;
    }
}
int d;

int RET(int code, int flag) {
    fprintf(stderr, "Result = %d (%d) (test = %d)\n", code, flag, d);
    exit(code);
}

int main(int argc, char** argv) {
    int i;

    if (argc != 4) {
        RET(255,0);
    }
    FILE* fin = fopen(argv[1], "r");
    FILE* foutbest = fopen(argv[2], "r");
    FILE* fout = fopen(argv[3], "r");
    if (!fin || !fout || !foutbest) {
        RET(255,0);
    }
    fscanf(fin, "%d", &d);
    while (d--) {
        fscanf(fin, "%d", &n);
        for (i=1; i<=n; ++i)
            fscanf(fin, "%d", &l[i]);

        int len;

        fscanf(fout, "%d", &len);
        if (len < 0 || len > MAX_L*3) RET(1,0);
        int bestlen;
        fscanf(foutbest, "%d", &bestlen);
        if (len > bestlen)
            RET(1,5);
        for (i=0; i<bestlen; ++i)
            fscanf(foutbest, "%*d");

        clear();

        // sprawdzamy poprawnosc uszeregowania
        for (i=0; i<len; ++i) {
            int x;
            fscanf(fout, "%d", &x);
            if (x == 0) continue;   // ok

            if (x < 0 || x > n) RET(1,1);  // too bad

            if (--lcnt[x] < 0) RET(1,2); // too bad

            if (lastpos[x] == -1) { // ok
                lastpos[x] = i;
                continue;           
            } else {
                if (lastpos[x] + 4 == i) { // ok
                    lastpos[x] = -1;
                    continue;
                } else {
                    RET(1,3); // too bad
                }
            }
        }
        for (i=1; i<=n; ++i) {
            if (lcnt[i] != 0) RET(1,4);
        }
        // TODO: optymalnosc
    }
    return 0;
}
